/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi;

import com.att.aft.dme2.hazelcast.core.ExecutionCallback;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.Operation;

public abstract class InvocationBuilder {
    public static final long DEFAULT_CALL_TIMEOUT = -1L;
    public static final int DEFAULT_REPLICA_INDEX = 0;
    public static final int DEFAULT_TRY_COUNT = 250;
    public static final long DEFAULT_TRY_PAUSE_MILLIS = 500L;
    public static final boolean DEFAULT_DESERIALIZE_RESULT = true;
    protected final String serviceName;
    protected final Operation op;
    protected final int partitionId;
    protected final Address target;
    protected ExecutionCallback<Object> executionCallback;
    protected long callTimeout = -1L;
    protected int replicaIndex;
    protected int tryCount = 250;
    protected long tryPauseMillis = 500L;
    protected boolean resultDeserialized = true;

    protected InvocationBuilder(String serviceName, Operation op, int partitionId, Address target) {
        this.serviceName = serviceName;
        this.op = op;
        this.partitionId = partitionId;
        this.target = target;
    }

    public InvocationBuilder setReplicaIndex(int replicaIndex) {
        if (replicaIndex < 0 || replicaIndex >= 7) {
            throw new IllegalArgumentException("Replica index is out of range [0-6]");
        }
        this.replicaIndex = replicaIndex;
        return this;
    }

    public boolean isResultDeserialized() {
        return this.resultDeserialized;
    }

    public InvocationBuilder setResultDeserialized(boolean resultDeserialized) {
        this.resultDeserialized = resultDeserialized;
        return this;
    }

    public InvocationBuilder setTryCount(int tryCount) {
        this.tryCount = tryCount;
        return this;
    }

    public InvocationBuilder setTryPauseMillis(long tryPauseMillis) {
        this.tryPauseMillis = tryPauseMillis;
        return this;
    }

    public InvocationBuilder setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Operation getOp() {
        return this.op;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public long getTryPauseMillis() {
        return this.tryPauseMillis;
    }

    public Address getTarget() {
        return this.target;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public ExecutionCallback<Object> getExecutionCallback() {
        return this.executionCallback;
    }

    public InvocationBuilder setExecutionCallback(ExecutionCallback<Object> executionCallback) {
        this.executionCallback = executionCallback;
        return this;
    }

    protected ExecutionCallback getTargetExecutionCallback() {
        return this.executionCallback;
    }

    public abstract <E> InternalCompletableFuture<E> invoke();
}

