/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.exception;

import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.spi.exception.RetryableHazelcastException;
import com.att.aft.dme2.hazelcast.util.StringUtil;

public class TargetDisconnectedException
extends RetryableHazelcastException {
    public TargetDisconnectedException() {
    }

    public TargetDisconnectedException(Address address) {
        super("Target[" + address + "] disconnected.");
    }

    public TargetDisconnectedException(String message) {
        super(message);
    }

    public TargetDisconnectedException(String message, Throwable cause) {
        super(message, cause);
    }

    public static Exception newTargetDisconnectedExceptionCausedByHeartbeat(Address memberAddress, String connectionString, long lastHeartbeatRequestedMillis, long lastHeartbeatReceivedMillis, long lastReadMillis, Throwable cause) {
        String msg = String.format("Disconnecting from member %s due to heartbeat problems. Current time: %s. Last heartbeat requested: %s. Last heartbeat received: %s. Last read: %s. Connection %s", memberAddress, StringUtil.timeToString(System.currentTimeMillis()), StringUtil.timeToStringFriendly(lastHeartbeatRequestedMillis), StringUtil.timeToStringFriendly(lastHeartbeatReceivedMillis), StringUtil.timeToStringFriendly(lastReadMillis), connectionString);
        return new TargetDisconnectedException(msg, cause);
    }

    public static Exception newTargetDisconnectedExceptionCausedByMemberLeftEvent(Member member, String connectionString) {
        String msg = String.format("Closing connection to member %s. The client has closed the connection to this member, after receiving a member left event from the cluster. Connection=%s", member.getAddress(), connectionString);
        return new TargetDisconnectedException(msg);
    }
}

