/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.impl;

import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import com.att.aft.dme2.hazelcast.spi.PartitionReplicationEvent;
import java.util.concurrent.atomic.AtomicInteger;

public class DelegatingMigrationAwareService
implements MigrationAwareService {
    private static final int PARTITION_OWNER_INDEX = 0;
    private final MigrationAwareService migrationAwareService;
    private final AtomicInteger ownerMigrationsInFlight;

    public DelegatingMigrationAwareService(MigrationAwareService migrationAwareService) {
        this.migrationAwareService = migrationAwareService;
        this.ownerMigrationsInFlight = new AtomicInteger();
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.migrationAwareService.prepareReplicationOperation(event);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        if (event.getCurrentReplicaIndex() == 0 || event.getNewReplicaIndex() == 0) {
            this.ownerMigrationsInFlight.incrementAndGet();
        }
        this.migrationAwareService.beforeMigration(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        try {
            this.migrationAwareService.commitMigration(event);
        }
        finally {
            if (event.getCurrentReplicaIndex() == 0 || event.getNewReplicaIndex() == 0) {
                int count = this.ownerMigrationsInFlight.decrementAndGet();
                assert (count >= 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        try {
            this.migrationAwareService.rollbackMigration(event);
        }
        finally {
            if (event.getCurrentReplicaIndex() == 0 || event.getNewReplicaIndex() == 0) {
                int count = this.ownerMigrationsInFlight.decrementAndGet();
                assert (count >= 0);
            }
        }
    }

    public int getOwnerMigrationsInFlight() {
        return this.ownerMigrationsInFlight.get();
    }
}

