/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.impl;

import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationResponseHandler;

public final class OperationResponseHandlerFactory {
    private static final NoResponseHandler EMPTY_RESPONSE_HANDLER = new NoResponseHandler();

    private OperationResponseHandlerFactory() {
    }

    public static OperationResponseHandler createEmptyResponseHandler() {
        return EMPTY_RESPONSE_HANDLER;
    }

    public static OperationResponseHandler createErrorLoggingResponseHandler(ILogger logger) {
        return new ErrorLoggingResponseHandler(logger);
    }

    private static final class ErrorLoggingResponseHandler
    implements OperationResponseHandler {
        private final ILogger logger;

        private ErrorLoggingResponseHandler(ILogger logger) {
            this.logger = logger;
        }

        public void sendResponse(Operation op, Object obj) {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                this.logger.severe(t);
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }

    private static class NoResponseHandler
    implements OperationResponseHandler {
        private NoResponseHandler() {
        }

        public void sendResponse(Operation op, Object obj) {
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }
}

