/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.impl.eventservice.impl.operations;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.att.aft.dme2.hazelcast.spi.impl.eventservice.impl.Registration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class PostJoinRegistrationOperation
extends AbstractOperation {
    private Collection<Registration> registrations;

    public PostJoinRegistrationOperation() {
    }

    public PostJoinRegistrationOperation(Collection<Registration> registrations) {
        this.registrations = registrations;
    }

    @Override
    public void run() throws Exception {
        if (this.registrations == null || this.registrations.size() <= 0) {
            return;
        }
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        EventServiceImpl eventService = (EventServiceImpl)nodeEngine.getEventService();
        for (Registration reg : this.registrations) {
            eventService.handleRegistration(reg);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int len = this.registrations != null ? this.registrations.size() : 0;
        out.writeInt(len);
        if (len > 0) {
            for (Registration reg : this.registrations) {
                reg.writeData(out);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int len = in.readInt();
        if (len > 0) {
            this.registrations = new ArrayList<Registration>(len);
            for (int i = 0; i < len; ++i) {
                Registration reg = new Registration();
                this.registrations.add(reg);
                reg.readData(in);
            }
        }
    }
}

