/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.impl.eventservice.impl.operations;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.att.aft.dme2.hazelcast.spi.impl.eventservice.impl.EventEnvelope;
import com.att.aft.dme2.hazelcast.spi.impl.eventservice.impl.EventProcessor;
import com.att.aft.dme2.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import java.io.IOException;

public class SendEventOperation
extends AbstractOperation
implements AllowedDuringPassiveState {
    private EventEnvelope eventEnvelope;
    private int orderKey;

    public SendEventOperation() {
    }

    public SendEventOperation(EventEnvelope eventEnvelope, int orderKey) {
        this.eventEnvelope = eventEnvelope;
        this.orderKey = orderKey;
    }

    @Override
    public void run() throws Exception {
        EventServiceImpl eventService = (EventServiceImpl)this.getNodeEngine().getEventService();
        eventService.executeEventCallback(new EventProcessor(eventService, this.eventEnvelope, this.orderKey));
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.eventEnvelope.writeData(out);
        out.writeInt(this.orderKey);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.eventEnvelope = new EventEnvelope();
        this.eventEnvelope.readData(in);
        this.orderKey = in.readInt();
    }
}

