/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl;

import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationFactory;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.operations.PartitionIteratingOperation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class InvokeOnPartitions {
    private static final int TRY_COUNT = 10;
    private static final int TRY_PAUSE_MILLIS = 300;
    private OperationServiceImpl operationService;
    private final String serviceName;
    private final OperationFactory operationFactory;
    private final Map<Address, List<Integer>> memberPartitions;
    private final Map<Address, Future> futures;
    private final Map<Integer, Object> partitionResults;

    InvokeOnPartitions(OperationServiceImpl operationService, String serviceName, OperationFactory operationFactory, Map<Address, List<Integer>> memberPartitions) {
        this.operationService = operationService;
        this.serviceName = serviceName;
        this.operationFactory = operationFactory;
        this.memberPartitions = memberPartitions;
        this.futures = new HashMap<Address, Future>(memberPartitions.size());
        int partitionCount = operationService.nodeEngine.getPartitionService().getPartitionCount();
        this.partitionResults = new HashMap<Integer, Object>(partitionCount);
    }

    Map<Integer, Object> invoke() throws Exception {
        this.ensureNotCallingFromOperationThread();
        this.invokeOnAllPartitions();
        this.awaitCompletion();
        this.retryFailedPartitions();
        return this.partitionResults;
    }

    private void ensureNotCallingFromOperationThread() {
        if (this.operationService.operationExecutor.isOperationThread()) {
            throw new IllegalThreadStateException(Thread.currentThread() + " cannot make invocation on multiple partitions!");
        }
    }

    private void invokeOnAllPartitions() {
        for (Map.Entry<Address, List<Integer>> mp : this.memberPartitions.entrySet()) {
            Address address = mp.getKey();
            List<Integer> partitions = mp.getValue();
            PartitionIteratingOperation operation = new PartitionIteratingOperation(this.operationFactory, partitions);
            InternalCompletableFuture future = this.operationService.createInvocationBuilder(this.serviceName, (Operation)operation, address).setTryCount(10).setTryPauseMillis(300L).invoke();
            this.futures.put(address, future);
        }
    }

    private void awaitCompletion() {
        NodeEngineImpl nodeEngine = this.operationService.nodeEngine;
        for (Map.Entry<Address, Future> response : this.futures.entrySet()) {
            try {
                Future future = response.getValue();
                PartitionIteratingOperation.PartitionResponse result = (PartitionIteratingOperation.PartitionResponse)nodeEngine.toObject(future.get());
                result.addResults(this.partitionResults);
            }
            catch (Throwable t) {
                if (this.operationService.logger.isFinestEnabled()) {
                    this.operationService.logger.finest(t);
                } else {
                    this.operationService.logger.warning(t.getMessage());
                }
                List<Integer> partitions = this.memberPartitions.get(response.getKey());
                for (Integer partition : partitions) {
                    this.partitionResults.put(partition, t);
                }
            }
        }
    }

    private void retryFailedPartitions() throws InterruptedException, ExecutionException {
        Object result;
        LinkedList<Integer> failedPartitions = new LinkedList<Integer>();
        for (Map.Entry<Integer, Object> partitionResult : this.partitionResults.entrySet()) {
            int partitionId = partitionResult.getKey();
            result = partitionResult.getValue();
            if (!(result instanceof Throwable)) continue;
            failedPartitions.add(partitionId);
        }
        for (Integer failedPartition : failedPartitions) {
            Operation operation = this.operationFactory instanceof PartitionAwareOperationFactory ? ((PartitionAwareOperationFactory)this.operationFactory).createPartitionOperation(failedPartition) : this.operationFactory.createOperation();
            InternalCompletableFuture future = this.operationService.createInvocationBuilder(this.serviceName, operation, failedPartition).invoke();
            this.partitionResults.put(failedPartition, future);
        }
        for (Integer failedPartition : failedPartitions) {
            Future future = (Future)this.partitionResults.get(failedPartition);
            result = future.get();
            this.partitionResults.put(failedPartition, result);
        }
    }
}

