/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl;

import com.att.aft.dme2.hazelcast.core.ExecutionCallback;
import com.att.aft.dme2.hazelcast.instance.MemberImpl;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.internal.cluster.ClusterClock;
import com.att.aft.dme2.hazelcast.internal.management.dto.SlowOperationDTO;
import com.att.aft.dme2.hazelcast.internal.metrics.MetricsProvider;
import com.att.aft.dme2.hazelcast.internal.metrics.MetricsRegistry;
import com.att.aft.dme2.hazelcast.internal.metrics.Probe;
import com.att.aft.dme2.hazelcast.internal.metrics.ProbeLevel;
import com.att.aft.dme2.hazelcast.internal.partition.InternalPartitionService;
import com.att.aft.dme2.hazelcast.internal.serialization.InternalSerializationService;
import com.att.aft.dme2.hazelcast.internal.util.counters.MwCounter;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.nio.ConnectionManager;
import com.att.aft.dme2.hazelcast.nio.Packet;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.InvocationBuilder;
import com.att.aft.dme2.hazelcast.spi.LiveOperations;
import com.att.aft.dme2.hazelcast.spi.LiveOperationsTracker;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationFactory;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.impl.PacketHandler;
import com.att.aft.dme2.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.att.aft.dme2.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.att.aft.dme2.hazelcast.spi.impl.operationexecutor.impl.OperationExecutorImpl;
import com.att.aft.dme2.hazelcast.spi.impl.operationexecutor.slowoperationdetector.SlowOperationDetector;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.AsyncResponseHandler;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.BackpressureRegulator;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.InvocationBuilderImpl;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.InvocationMonitor;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.InvokeOnPartitions;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.OperationBackupHandler;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.OperationRunnerFactoryImpl;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.PartitionInvocation;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.ResponseHandler;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.TargetInvocation;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.responses.Response;
import com.att.aft.dme2.hazelcast.spi.impl.operationutil.Operations;
import com.att.aft.dme2.hazelcast.spi.properties.GroupProperty;
import com.att.aft.dme2.hazelcast.util.EmptyStatement;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import com.att.aft.dme2.hazelcast.util.executor.ExecutorType;
import com.att.aft.dme2.hazelcast.util.executor.ManagedExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class OperationServiceImpl
implements InternalOperationService,
MetricsProvider,
LiveOperationsTracker {
    private static final int CORE_SIZE_CHECK = 8;
    private static final int CORE_SIZE_FACTOR = 4;
    private static final int CONCURRENCY_LEVEL = 16;
    private static final int ASYNC_QUEUE_CAPACITY = 100000;
    private static final long TERMINATION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    final InvocationRegistry invocationRegistry;
    final OperationExecutor operationExecutor;
    @Probe(name="completedCount", level=ProbeLevel.MANDATORY)
    final AtomicLong completedOperationsCount = new AtomicLong();
    @Probe(name="operationTimeoutCount", level=ProbeLevel.MANDATORY)
    final MwCounter operationTimeoutCount = MwCounter.newMwCounter();
    @Probe(name="callTimeoutCount", level=ProbeLevel.MANDATORY)
    final MwCounter callTimeoutCount = MwCounter.newMwCounter();
    @Probe(name="retryCount", level=ProbeLevel.MANDATORY)
    final MwCounter retryCount = MwCounter.newMwCounter();
    final NodeEngineImpl nodeEngine;
    final Node node;
    final ILogger logger;
    final OperationBackupHandler operationBackupHandler;
    final BackpressureRegulator backpressureRegulator;
    volatile Invocation.Context invocationContext;
    private final InvocationMonitor invocationMonitor;
    private final SlowOperationDetector slowOperationDetector;
    private final AsyncResponseHandler asyncResponseHandler;
    private final InternalSerializationService serializationService;
    private final ResponseHandler responseHandler;
    private final Address thisAddress;

    public OperationServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.node = nodeEngine.getNode();
        this.thisAddress = this.node.getThisAddress();
        this.logger = this.node.getLogger(OperationService.class);
        this.serializationService = (InternalSerializationService)nodeEngine.getSerializationService();
        this.backpressureRegulator = new BackpressureRegulator(this.node.getProperties(), this.node.getLogger(BackpressureRegulator.class));
        int coreSize = Runtime.getRuntime().availableProcessors();
        boolean reallyMultiCore = coreSize >= 8;
        int concurrencyLevel = reallyMultiCore ? coreSize * 4 : 16;
        this.invocationRegistry = new InvocationRegistry(this.node.getLogger(OperationServiceImpl.class), this.backpressureRegulator.newCallIdSequence(), concurrencyLevel);
        this.invocationMonitor = new InvocationMonitor(nodeEngine, this.thisAddress, this.node.getHazelcastThreadGroup(), this.node.getProperties(), this.invocationRegistry, this.node.getLogger(InvocationMonitor.class), this.serializationService, nodeEngine.getServiceManager());
        this.operationBackupHandler = new OperationBackupHandler(this);
        this.responseHandler = new ResponseHandler(this.node.getLogger(ResponseHandler.class), this.node.getSerializationService(), this.invocationRegistry, nodeEngine);
        this.asyncResponseHandler = new AsyncResponseHandler(this.node.getHazelcastThreadGroup(), this.node.getLogger(AsyncResponseHandler.class), this.responseHandler, this.node.getProperties());
        this.operationExecutor = new OperationExecutorImpl(this.node.getProperties(), this.node.loggingService, this.thisAddress, new OperationRunnerFactoryImpl(this), this.node.getHazelcastThreadGroup(), this.node.getNodeExtension());
        this.slowOperationDetector = new SlowOperationDetector(this.node.loggingService, this.operationExecutor.getGenericOperationRunners(), this.operationExecutor.getPartitionOperationRunners(), this.node.getProperties(), this.node.getHazelcastThreadGroup());
    }

    @Override
    public void populate(LiveOperations result) {
        this.operationExecutor.scan(result);
    }

    public PacketHandler getAsyncResponseHandler() {
        return this.asyncResponseHandler;
    }

    public InvocationMonitor getInvocationMonitor() {
        return this.invocationMonitor;
    }

    @Override
    public List<SlowOperationDTO> getSlowOperationDTOs() {
        return this.slowOperationDetector.getSlowOperationDTOs();
    }

    public InvocationRegistry getInvocationRegistry() {
        return this.invocationRegistry;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    @Override
    public int getPartitionThreadCount() {
        return this.operationExecutor.getPartitionThreadCount();
    }

    @Override
    public int getGenericThreadCount() {
        return this.operationExecutor.getGenericThreadCount();
    }

    @Override
    public int getRunningOperationsCount() {
        return this.operationExecutor.getRunningOperationCount();
    }

    @Override
    public long getExecutedOperationCount() {
        return this.completedOperationsCount.get();
    }

    @Override
    public int getRemoteOperationsCount() {
        return this.invocationRegistry.size();
    }

    @Override
    public int getOperationExecutorQueueSize() {
        return this.operationExecutor.getQueueSize();
    }

    @Override
    public int getPriorityOperationExecutorQueueSize() {
        return this.operationExecutor.getPriorityQueueSize();
    }

    public OperationExecutor getOperationExecutor() {
        return this.operationExecutor;
    }

    @Override
    public int getResponseQueueSize() {
        return this.asyncResponseHandler.getQueueSize();
    }

    @Override
    public void execute(PartitionSpecificRunnable task) {
        this.operationExecutor.execute(task);
    }

    @Override
    public InvocationBuilder createInvocationBuilder(String serviceName, Operation op, int partitionId) {
        Preconditions.checkNotNegative(partitionId, "Partition id cannot be negative!");
        return new InvocationBuilderImpl(this.invocationContext, serviceName, op, partitionId);
    }

    @Override
    public InvocationBuilder createInvocationBuilder(String serviceName, Operation op, Address target) {
        Preconditions.checkNotNull(target, "Target cannot be null!");
        return new InvocationBuilderImpl(this.invocationContext, serviceName, op, target);
    }

    @Override
    public void runOperationOnCallingThread(Operation op) {
        this.run(op);
    }

    @Override
    public void run(Operation op) {
        this.operationExecutor.run(op);
    }

    @Override
    public void executeOperation(Operation op) {
        this.execute(op);
    }

    @Override
    public void execute(Operation op) {
        this.operationExecutor.execute(op);
    }

    @Override
    public boolean isRunAllowed(Operation op) {
        return this.operationExecutor.isRunAllowed(op);
    }

    @Override
    public <E> InternalCompletableFuture<E> invokeOnPartition(String serviceName, Operation op, int partitionId) {
        op.setServiceName(serviceName).setPartitionId(partitionId).setReplicaIndex(0);
        return new PartitionInvocation(this.invocationContext, op, 250, 500L, -1L, true).invoke();
    }

    @Override
    public <E> InternalCompletableFuture<E> invokeOnPartition(Operation op) {
        return new PartitionInvocation(this.invocationContext, op, 250, 500L, -1L, true).invoke();
    }

    @Override
    public <E> InternalCompletableFuture<E> invokeOnTarget(String serviceName, Operation op, Address target) {
        op.setServiceName(serviceName);
        return new TargetInvocation(this.invocationContext, op, target, 250, 500L, -1L, true).invoke();
    }

    @Override
    public <V> void asyncInvokeOnPartition(String serviceName, Operation op, int partitionId, ExecutionCallback<V> callback) {
        op.setServiceName(serviceName).setPartitionId(partitionId).setReplicaIndex(0);
        InvocationFuture future = new PartitionInvocation(this.invocationContext, op, 250, 500L, -1L, true).invokeAsync();
        if (callback != null) {
            future.andThen(callback);
        }
    }

    @Override
    public boolean isCallTimedOut(Operation op) {
        if (!op.returnsResponse() || Operations.isJoinOperation(op)) {
            return false;
        }
        long callTimeout = op.getCallTimeout();
        long invocationTime = op.getInvocationTime();
        long expireTime = invocationTime + callTimeout;
        if (expireTime <= 0L || expireTime == Long.MAX_VALUE) {
            return false;
        }
        ClusterClock clusterClock = this.nodeEngine.getClusterService().getClusterClock();
        long now = clusterClock.getClusterTime();
        return expireTime < now;
    }

    @Override
    public Map<Integer, Object> invokeOnAllPartitions(String serviceName, OperationFactory operationFactory) throws Exception {
        Map<Address, List<Integer>> memberPartitions = this.nodeEngine.getPartitionService().getMemberPartitionsMap();
        InvokeOnPartitions invokeOnPartitions = new InvokeOnPartitions(this, serviceName, operationFactory, memberPartitions);
        return invokeOnPartitions.invoke();
    }

    @Override
    public Map<Integer, Object> invokeOnPartitions(String serviceName, OperationFactory operationFactory, Collection<Integer> partitions) throws Exception {
        HashMap<Address, List<Integer>> memberPartitions = new HashMap<Address, List<Integer>>(3);
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        for (int partition : partitions) {
            Address owner = partitionService.getPartitionOwnerOrWait(partition);
            if (!memberPartitions.containsKey(owner)) {
                memberPartitions.put(owner, new ArrayList());
            }
            ((List)memberPartitions.get(owner)).add(partition);
        }
        InvokeOnPartitions invokeOnPartitions = new InvokeOnPartitions(this, serviceName, operationFactory, memberPartitions);
        return invokeOnPartitions.invoke();
    }

    @Override
    public Map<Integer, Object> invokeOnPartitions(String serviceName, OperationFactory operationFactory, int[] partitions) throws Exception {
        HashMap<Address, List<Integer>> memberPartitions = new HashMap<Address, List<Integer>>(3);
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        for (int partition : partitions) {
            Address owner = partitionService.getPartitionOwnerOrWait(partition);
            if (!memberPartitions.containsKey(owner)) {
                memberPartitions.put(owner, new ArrayList());
            }
            ((List)memberPartitions.get(owner)).add(partition);
        }
        InvokeOnPartitions invokeOnPartitions = new InvokeOnPartitions(this, serviceName, operationFactory, memberPartitions);
        return invokeOnPartitions.invoke();
    }

    @Override
    public boolean send(Operation op, Address target) {
        Preconditions.checkNotNull(target, "Target is required!");
        if (this.thisAddress.equals(target)) {
            throw new IllegalArgumentException("Target is this node! -> " + target + ", op: " + op);
        }
        byte[] bytes = this.serializationService.toBytes(op);
        int partitionId = op.getPartitionId();
        Packet packet = new Packet(bytes, partitionId).setFlag(1);
        if (op.isUrgent()) {
            packet.setFlag(16);
        }
        ConnectionManager connectionManager = this.node.getConnectionManager();
        Connection connection = connectionManager.getOrConnect(target);
        return connectionManager.transmit(packet, connection);
    }

    public boolean send(Response response, Address target) {
        Preconditions.checkNotNull(target, "Target is required!");
        if (this.thisAddress.equals(target)) {
            throw new IllegalArgumentException("Target is this node! -> " + target + ", response: " + response);
        }
        byte[] bytes = this.serializationService.toBytes(response);
        Packet packet = new Packet(bytes, -1).setAllFlags(3);
        if (response.isUrgent()) {
            packet.setFlag(16);
        }
        ConnectionManager connectionManager = this.node.getConnectionManager();
        Connection connection = connectionManager.getOrConnect(target);
        return connectionManager.transmit(packet, connection);
    }

    public void onMemberLeft(MemberImpl member) {
        this.invocationMonitor.onMemberLeft(member);
    }

    public void reset() {
        this.invocationRegistry.reset();
    }

    @Override
    public void provideMetrics(MetricsRegistry metricsRegistry) {
        metricsRegistry.scanAndRegister(this, "operation");
        metricsRegistry.collectMetrics(this.invocationRegistry, this.invocationMonitor, this.responseHandler, this.asyncResponseHandler, this.operationExecutor);
    }

    public void start() {
        this.logger.finest("Starting OperationService");
        ManagedExecutorService asyncExecutor = this.nodeEngine.getExecutionService().register("hz:async", Runtime.getRuntime().availableProcessors(), 100000, ExecutorType.CONCRETE);
        this.invocationContext = new Invocation.Context(asyncExecutor, this.nodeEngine.getClusterService().getClusterClock(), this.nodeEngine.getClusterService(), this.node.connectionManager, this.node.nodeEngine.getExecutionService(), this.nodeEngine.getProperties().getMillis(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS), this.invocationRegistry, this.invocationMonitor, this.nodeEngine.getLocalMember().getUuid(), this.nodeEngine.getLogger(Invocation.class), this.node, this.nodeEngine, this.nodeEngine.getPartitionService(), this, this.operationExecutor, this.retryCount, this.serializationService, this.nodeEngine.getThisAddress());
        this.invocationMonitor.start();
        this.operationExecutor.start();
        this.asyncResponseHandler.start();
        this.slowOperationDetector.start();
    }

    public void shutdownInvocations() {
        this.logger.finest("Shutting down invocations");
        this.invocationRegistry.shutdown();
        this.invocationMonitor.shutdown();
        this.asyncResponseHandler.shutdown();
        try {
            this.invocationMonitor.awaitTermination(TERMINATION_TIMEOUT_MILLIS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            EmptyStatement.ignore(e);
        }
    }

    public void shutdownOperationExecutor() {
        this.logger.finest("Shutting down operation executors");
        this.operationExecutor.shutdown();
        this.slowOperationDetector.shutdown();
    }
}

