/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl;

import com.att.aft.dme2.hazelcast.internal.metrics.MetricsProvider;
import com.att.aft.dme2.hazelcast.internal.metrics.MetricsRegistry;
import com.att.aft.dme2.hazelcast.internal.metrics.Probe;
import com.att.aft.dme2.hazelcast.internal.metrics.ProbeLevel;
import com.att.aft.dme2.hazelcast.internal.partition.ReplicaErrorLogger;
import com.att.aft.dme2.hazelcast.internal.serialization.InternalSerializationService;
import com.att.aft.dme2.hazelcast.internal.util.counters.MwCounter;
import com.att.aft.dme2.hazelcast.internal.util.counters.SwCounter;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.Packet;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.impl.PacketHandler;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.responses.BackupAckResponse;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.responses.Response;

public final class ResponseHandler
implements PacketHandler,
MetricsProvider {
    private final ILogger logger;
    private final InternalSerializationService serializationService;
    private final InvocationRegistry invocationRegistry;
    private final NodeEngineImpl nodeEngine;
    @Probe(name="responses[normal]", level=ProbeLevel.MANDATORY)
    private final SwCounter responsesNormal = SwCounter.newSwCounter();
    @Probe(name="responses[timeout]", level=ProbeLevel.MANDATORY)
    private final SwCounter responsesTimeout = SwCounter.newSwCounter();
    @Probe(name="responses[backup]", level=ProbeLevel.MANDATORY)
    private final MwCounter responsesBackup = MwCounter.newMwCounter();
    @Probe(name="responses[error]", level=ProbeLevel.MANDATORY)
    private final SwCounter responsesError = SwCounter.newSwCounter();
    @Probe(name="responses[missing]", level=ProbeLevel.MANDATORY)
    private final MwCounter responsesMissing = MwCounter.newMwCounter();

    ResponseHandler(ILogger logger, InternalSerializationService serializationService, InvocationRegistry invocationRegistry, NodeEngineImpl nodeEngine) {
        this.logger = logger;
        this.serializationService = serializationService;
        this.invocationRegistry = invocationRegistry;
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void provideMetrics(MetricsRegistry metricsRegistry) {
        metricsRegistry.scanAndRegister(this, "operation.invocations");
    }

    @Override
    public void handle(Packet packet) throws Exception {
        Response response = (Response)this.serializationService.toObject(packet);
        Address sender = packet.getConn().getEndPoint();
        try {
            if (response instanceof NormalResponse) {
                NormalResponse normalResponse = (NormalResponse)response;
                this.notifyNormalResponse(normalResponse.getCallId(), normalResponse.getValue(), normalResponse.getBackupAcks(), sender);
            } else if (response instanceof BackupAckResponse) {
                this.notifyBackupComplete(response.getCallId());
            } else if (response instanceof CallTimeoutResponse) {
                this.notifyCallTimeout(response.getCallId(), sender);
            } else if (response instanceof ErrorResponse) {
                ErrorResponse errorResponse = (ErrorResponse)response;
                this.notifyErrorResponse(errorResponse.getCallId(), errorResponse.getCause(), sender);
            } else {
                this.logger.severe("Unrecognized response: " + response);
            }
        }
        catch (Throwable e) {
            this.logger.severe("While processing response...", e);
        }
    }

    public void notifyBackupComplete(long callId) {
        this.responsesBackup.inc();
        try {
            Invocation invocation = this.invocationRegistry.get(callId);
            if (invocation == null) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("No Invocation found for backup response with callId " + callId);
                }
                return;
            }
            invocation.notifyBackupComplete();
        }
        catch (Exception e) {
            ReplicaErrorLogger.log(e, this.logger);
        }
    }

    void notifyErrorResponse(long callId, Object cause, Address sender) {
        this.responsesError.inc();
        Invocation invocation = this.invocationRegistry.get(callId);
        if (invocation == null) {
            this.responsesMissing.inc();
            if (this.nodeEngine.isRunning()) {
                this.logger.warning("No Invocation found for error response with callId: " + callId + " sent from " + sender);
            }
            return;
        }
        invocation.notifyError(cause);
    }

    void notifyNormalResponse(long callId, Object value, int backupCount, Address sender) {
        this.responsesNormal.inc();
        Invocation invocation = this.invocationRegistry.get(callId);
        if (invocation == null) {
            this.responsesMissing.inc();
            if (this.nodeEngine.isRunning()) {
                this.logger.warning("No Invocation found for normal response with callId " + callId + " sent from " + sender);
            }
            return;
        }
        invocation.notifyNormalResponse(value, backupCount);
    }

    void notifyCallTimeout(long callId, Address sender) {
        this.responsesTimeout.inc();
        Invocation invocation = this.invocationRegistry.get(callId);
        if (invocation == null) {
            this.responsesMissing.inc();
            if (this.nodeEngine.isRunning()) {
                this.logger.warning("No Invocation found for call timeout response with callId" + callId + " sent from " + sender);
            }
            return;
        }
        invocation.notifyCallTimeout();
    }
}

