/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.impl.packetdispatcher.impl;

import com.att.aft.dme2.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Packet;
import com.att.aft.dme2.hazelcast.spi.impl.PacketHandler;
import com.att.aft.dme2.hazelcast.spi.impl.packetdispatcher.PacketDispatcher;

public final class PacketDispatcherImpl
implements PacketDispatcher {
    private final ILogger logger;
    private final PacketHandler eventService;
    private final PacketHandler operationExecutor;
    private final PacketHandler connectionManager;
    private final PacketHandler responseHandler;
    private final PacketHandler invocationMonitor;

    public PacketDispatcherImpl(ILogger logger, PacketHandler operationExecutor, PacketHandler responseHandler, PacketHandler invocationMonitor, PacketHandler eventService, PacketHandler connectionManager) {
        this.logger = logger;
        this.responseHandler = responseHandler;
        this.eventService = eventService;
        this.invocationMonitor = invocationMonitor;
        this.connectionManager = connectionManager;
        this.operationExecutor = operationExecutor;
    }

    @Override
    public void dispatch(Packet packet) {
        try {
            if (packet.isFlagSet(1)) {
                if (packet.isFlagSet(2)) {
                    this.responseHandler.handle(packet);
                } else if (packet.isFlagSet(64)) {
                    this.invocationMonitor.handle(packet);
                } else {
                    this.operationExecutor.handle(packet);
                }
            } else if (packet.isFlagSet(4)) {
                this.eventService.handle(packet);
            } else if (packet.isFlagSet(32)) {
                this.connectionManager.handle(packet);
            } else {
                this.logger.severe("Unknown packet type! Header: " + packet.getFlags());
            }
        }
        catch (Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
            this.logger.severe("Failed to process:" + packet, t);
        }
    }
}

