/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi.impl.proxyservice.impl.operations;

import com.att.aft.dme2.hazelcast.core.DistributedObject;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.ExecutionService;
import com.att.aft.dme2.hazelcast.spi.InitializingObject;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.impl.proxyservice.impl.ProxyInfo;
import com.att.aft.dme2.hazelcast.spi.impl.proxyservice.impl.ProxyRegistry;
import com.att.aft.dme2.hazelcast.spi.impl.proxyservice.impl.ProxyServiceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class PostJoinProxyOperation
extends AbstractOperation {
    private Collection<ProxyInfo> proxies;

    public PostJoinProxyOperation() {
    }

    public PostJoinProxyOperation(Collection<ProxyInfo> proxies) {
        this.proxies = proxies;
    }

    @Override
    public void run() throws Exception {
        if (this.proxies == null || this.proxies.size() <= 0) {
            return;
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        ProxyServiceImpl proxyService = (ProxyServiceImpl)this.getService();
        ExecutionService executionService = nodeEngine.getExecutionService();
        for (final ProxyInfo proxy : this.proxies) {
            final ProxyRegistry registry = proxyService.getOrCreateRegistry(proxy.getServiceName());
            try {
                executionService.execute("hz:system", new Runnable(){

                    @Override
                    public void run() {
                        registry.createProxy(proxy.getObjectName(), false, true);
                    }
                });
            }
            catch (Throwable t) {
                this.getLogger().warning("Cannot create proxy [" + proxy.getServiceName() + ":" + proxy.getObjectName() + "]!", t);
            }
        }
    }

    @Override
    public String getServiceName() {
        return "hz:core:proxyService";
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int len = this.proxies != null ? this.proxies.size() : 0;
        out.writeInt(len);
        if (len > 0) {
            for (ProxyInfo proxy : this.proxies) {
                out.writeUTF(proxy.getServiceName());
                out.writeObject(proxy.getObjectName());
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int len = in.readInt();
        if (len > 0) {
            this.proxies = new ArrayList<ProxyInfo>(len);
            for (int i = 0; i < len; ++i) {
                ProxyInfo proxy = new ProxyInfo(in.readUTF(), (String)in.readObject());
                this.proxies.add(proxy);
            }
        }
    }

    private class InitializeRunnable
    implements Runnable {
        private final DistributedObject object;

        public InitializeRunnable(DistributedObject object) {
            this.object = object;
        }

        @Override
        public void run() {
            try {
                ((InitializingObject)((Object)this.object)).initialize();
            }
            catch (Exception e) {
                PostJoinProxyOperation.this.getLogger().warning("Error while initializing proxy: " + this.object, e);
            }
        }
    }
}

