/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.topic.impl;

import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.topic.impl.TopicDataSerializerHook;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.io.IOException;

public class TopicEvent
implements IdentifiedDataSerializable {
    public String name;
    public long publishTime;
    public Address publisherAddress;
    public Data data;

    public TopicEvent() {
    }

    public TopicEvent(String name, Data data, Address publisherAddress) {
        this.name = name;
        this.publishTime = Clock.currentTimeMillis();
        this.publisherAddress = publisherAddress;
        this.data = data;
    }

    @Override
    public int getFactoryId() {
        return TopicDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.publishTime);
        out.writeObject(this.publisherAddress);
        out.writeData(this.data);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.publishTime = in.readLong();
        this.publisherAddress = (Address)in.readObject();
        this.data = in.readData();
    }

    public String toString() {
        return "TopicEvent{name='" + this.name + '\'' + ", publishTime=" + this.publishTime + ", publisherAddress=" + this.publisherAddress + '}';
    }
}

