/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.topic.impl.reliable;

import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.topic.impl.TopicDataSerializerHook;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.io.IOException;

public class ReliableTopicMessage
implements IdentifiedDataSerializable {
    private long publishTime;
    private Address publisherAddress;
    private Data payload;

    public ReliableTopicMessage() {
    }

    public ReliableTopicMessage(Data payload, Address publisherAddress) {
        this.publishTime = Clock.currentTimeMillis();
        this.publisherAddress = publisherAddress;
        this.payload = payload;
    }

    public long getPublishTime() {
        return this.publishTime;
    }

    public Address getPublisherAddress() {
        return this.publisherAddress;
    }

    public Data getPayload() {
        return this.payload;
    }

    @Override
    public int getFactoryId() {
        return TopicDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.publishTime);
        out.writeObject(this.publisherAddress);
        out.writeData(this.payload);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.publishTime = in.readLong();
        this.publisherAddress = (Address)in.readObject();
        this.payload = in.readData();
    }
}

