/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.transaction.impl;

import com.att.aft.dme2.hazelcast.core.ExecutionCallback;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.att.aft.dme2.hazelcast.transaction.impl.TargetAwareTransactionLogRecord;
import com.att.aft.dme2.hazelcast.transaction.impl.TransactionLogRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Future;

public class TransactionLog {
    private final List<TransactionLogRecord> recordList = new LinkedList<TransactionLogRecord>();
    private final Map<Object, TransactionLogRecord> recordMap = new HashMap<Object, TransactionLogRecord>();

    public TransactionLog() {
    }

    public TransactionLog(List<TransactionLogRecord> transactionLog) {
        this.recordList.addAll(transactionLog);
    }

    public void add(TransactionLogRecord record) {
        TransactionLogRecord removed;
        Object key = record.getKey();
        if (key != null && (removed = this.recordMap.remove(key)) != null) {
            this.recordList.remove(removed);
        }
        this.recordList.add(record);
        if (key != null) {
            this.recordMap.put(key, record);
        }
    }

    public TransactionLogRecord get(Object key) {
        return this.recordMap.get(key);
    }

    public List<TransactionLogRecord> getRecordList() {
        return this.recordList;
    }

    public void remove(Object key) {
        TransactionLogRecord removed = this.recordMap.remove(key);
        if (removed != null) {
            this.recordList.remove(removed);
        }
    }

    public int size() {
        return this.recordList.size();
    }

    public List<Future> commit(NodeEngine nodeEngine) {
        ArrayList<Future> futures = new ArrayList<Future>(this.size());
        for (TransactionLogRecord record : this.recordList) {
            Future future = this.invoke(nodeEngine, record, record.newCommitOperation());
            futures.add(future);
        }
        return futures;
    }

    public List<Future> prepare(NodeEngine nodeEngine) {
        ArrayList<Future> futures = new ArrayList<Future>(this.size());
        for (TransactionLogRecord record : this.recordList) {
            Future future = this.invoke(nodeEngine, record, record.newPrepareOperation());
            futures.add(future);
        }
        return futures;
    }

    public List<Future> rollback(NodeEngine nodeEngine) {
        ArrayList<Future> futures = new ArrayList<Future>(this.size());
        ListIterator<TransactionLogRecord> iterator = this.recordList.listIterator(this.size());
        while (iterator.hasPrevious()) {
            TransactionLogRecord record = iterator.previous();
            Future future = this.invoke(nodeEngine, record, record.newRollbackOperation());
            futures.add(future);
        }
        return futures;
    }

    private Future invoke(NodeEngine nodeEngine, TransactionLogRecord record, Operation op) {
        OperationService operationService = nodeEngine.getOperationService();
        if (record instanceof TargetAwareTransactionLogRecord) {
            Address target = ((TargetAwareTransactionLogRecord)record).getTarget();
            return operationService.invokeOnTarget(op.getServiceName(), op, target);
        }
        return operationService.invokeOnPartition(op.getServiceName(), op, op.getPartitionId());
    }

    public void commitAsync(NodeEngine nodeEngine, ExecutionCallback callback) {
        for (TransactionLogRecord record : this.recordList) {
            this.invokeAsync(nodeEngine, callback, record, record.newCommitOperation());
        }
    }

    public void rollbackAsync(NodeEngine nodeEngine, ExecutionCallback callback) {
        for (TransactionLogRecord record : this.recordList) {
            this.invokeAsync(nodeEngine, callback, record, record.newRollbackOperation());
        }
    }

    private void invokeAsync(NodeEngine nodeEngine, ExecutionCallback callback, TransactionLogRecord record, Operation op) {
        InternalOperationService operationService = (InternalOperationService)nodeEngine.getOperationService();
        if (record instanceof TargetAwareTransactionLogRecord) {
            Address target = ((TargetAwareTransactionLogRecord)record).getTarget();
            operationService.invokeOnTarget(op.getServiceName(), op, target);
        } else {
            operationService.asyncInvokeOnPartition(op.getServiceName(), op, op.getPartitionId(), callback);
        }
    }
}

