/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.util;

import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static <K, V> List<V> addToValueList(Map<K, List<V>> map, K key, V value) {
        List<V> valueList = map.get(key);
        if (valueList == null) {
            valueList = new ArrayList<V>();
            map.put(key, valueList);
        }
        valueList.add(value);
        return valueList;
    }

    public static <T> T getItemAtPositionOrNull(Collection<T> collection, int position) {
        if (position >= collection.size()) {
            return null;
        }
        if (collection instanceof List) {
            return (T)((List)collection).get(position);
        }
        Iterator<T> iterator = collection.iterator();
        T item = null;
        for (int i = 0; i < position + 1; ++i) {
            item = iterator.next();
        }
        return item;
    }

    public static <C> Collection<Data> objectToDataCollection(Collection<C> collection, SerializationService serializationService) {
        ArrayList<Data> dataKeys = new ArrayList<Data>(collection.size());
        for (C item : collection) {
            Preconditions.checkNotNull(item);
            dataKeys.add((Data)serializationService.toData(item));
        }
        return dataKeys;
    }

    public static int[] toIntArray(Collection<Integer> collection) {
        int[] collectionArray = new int[collection.size()];
        int index = 0;
        for (Integer item : collection) {
            collectionArray[index++] = item;
        }
        return collectionArray;
    }

    public static long[] toLongArray(Collection<Long> collection) {
        long[] collectionArray = new long[collection.size()];
        int index = 0;
        for (Long item : collection) {
            collectionArray[index++] = item;
        }
        return collectionArray;
    }
}

