/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.util;

import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import com.att.aft.dme2.hazelcast.util.ContextMutexFactory;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ConcurrencyUtil {
    private ConcurrencyUtil() {
    }

    public static <E> void setMax(E obj, AtomicLongFieldUpdater<E> updater, long value) {
        long current;
        do {
            if ((current = updater.get(obj)) < value) continue;
            return;
        } while (!updater.compareAndSet(obj, current, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrPutSynchronized(ConcurrentMap<K, V> map, K key, Object mutex, ConstructorFunction<K, V> func) {
        if (mutex == null) {
            throw new NullPointerException();
        }
        Object value = map.get(key);
        if (value == null) {
            Object object = mutex;
            synchronized (object) {
                value = map.get(key);
                if (value == null) {
                    value = func.createNew(key);
                    map.put(key, value);
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrPutSynchronized(ConcurrentMap<K, V> map, K key, ContextMutexFactory contextMutexFactory, ConstructorFunction<K, V> func) {
        if (contextMutexFactory == null) {
            throw new NullPointerException();
        }
        Object value = map.get(key);
        if (value == null) {
            ContextMutexFactory.Mutex mutex = contextMutexFactory.mutexFor(key);
            try {
                ContextMutexFactory.Mutex mutex2 = mutex;
                synchronized (mutex2) {
                    value = map.get(key);
                    if (value == null) {
                        value = func.createNew(key);
                        map.put(key, value);
                    }
                }
            }
            finally {
                mutex.close();
            }
        }
        return value;
    }

    public static <K, V> V getOrPutIfAbsent(ConcurrentMap<K, V> map, K key, ConstructorFunction<K, V> func) {
        Object value = map.get(key);
        if (value == null) {
            value = func.createNew(key);
            V current = map.putIfAbsent(key, value);
            value = current == null ? value : current;
        }
        return value;
    }
}

