/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.util;

import com.att.aft.dme2.hazelcast.util.EmptyStatement;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public final class OperatingSystemMXBeanSupport {
    private static final OperatingSystemMXBean OPERATING_SYSTEM_MX_BEAN = ManagementFactory.getOperatingSystemMXBean();
    private static final double PERCENTAGE_MULTIPLIER = 100.0;

    private OperatingSystemMXBeanSupport() {
    }

    public static long readLongAttribute(String attributeName, long defaultValue) {
        try {
            String methodName = "get" + attributeName;
            OperatingSystemMXBean systemMXBean = OPERATING_SYSTEM_MX_BEAN;
            Method method = systemMXBean.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Object value = method.invoke((Object)systemMXBean, new Object[0]);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Double) {
                double v = (Double)value;
                return Math.round(v * 100.0);
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        return defaultValue;
    }

    public static double getSystemLoadAverage() {
        return OPERATING_SYSTEM_MX_BEAN.getSystemLoadAverage();
    }
}

