/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.util;

import com.att.aft.dme2.hazelcast.core.HazelcastException;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.logging.Logger;
import com.att.aft.dme2.hazelcast.nio.ClassLoaderUtil;
import com.att.aft.dme2.hazelcast.nio.IOUtil;
import com.att.aft.dme2.hazelcast.util.EmptyStatement;
import com.att.aft.dme2.hazelcast.util.FilteringClassLoader;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class ServiceLoader {
    private static final ILogger LOGGER = Logger.getLogger(ServiceLoader.class);
    private static final String FILTERING_CLASS_LOADER = FilteringClassLoader.class.getCanonicalName();
    private static final String IGNORED_GLASSFISH_MAGIC_CLASSLOADER = "com.sun.enterprise.v3.server.APIClassLoaderServiceImpl$APIClassLoader";

    private ServiceLoader() {
    }

    public static <T> T load(Class<T> clazz, String factoryId, ClassLoader classLoader) throws Exception {
        Iterator<T> iterator = ServiceLoader.iterator(clazz, factoryId, classLoader);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> Iterator<T> iterator(Class<T> clazz, String factoryId, ClassLoader classLoader) throws Exception {
        Set<ServiceDefinition> serviceDefinitions = ServiceLoader.getServiceDefinitions(factoryId, classLoader);
        return new NewInstanceIterator<T>(serviceDefinitions, clazz);
    }

    public static <T> Iterator<Class<T>> classIterator(String factoryId, ClassLoader classLoader) throws Exception {
        Set<ServiceDefinition> serviceDefinitions = ServiceLoader.getServiceDefinitions(factoryId, classLoader);
        return new LoadClassIterator(serviceDefinitions);
    }

    private static Set<ServiceDefinition> getServiceDefinitions(String factoryId, ClassLoader classLoader) {
        List<ClassLoader> classLoaders = ServiceLoader.selectClassLoaders(classLoader);
        HashSet<URLDefinition> factoryUrls = new HashSet<URLDefinition>();
        for (ClassLoader selectedClassLoader : classLoaders) {
            factoryUrls.addAll(ServiceLoader.collectFactoryUrls(factoryId, selectedClassLoader));
        }
        HashSet<ServiceDefinition> serviceDefinitions = new HashSet<ServiceDefinition>();
        for (URLDefinition urlDefinition : factoryUrls) {
            serviceDefinitions.addAll(ServiceLoader.parse(urlDefinition));
        }
        if (serviceDefinitions.isEmpty()) {
            Logger.getLogger(ServiceLoader.class).finest("Service loader could not load 'META-INF/services/" + factoryId + "' It may be empty or does not exist.");
        }
        return serviceDefinitions;
    }

    private static Set<URLDefinition> collectFactoryUrls(String factoryId, ClassLoader classLoader) {
        String resourceName = "META-INF/services/" + factoryId;
        try {
            Enumeration<URL> configs = classLoader != null ? classLoader.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
            HashSet<URLDefinition> urlDefinitions = new HashSet<URLDefinition>();
            while (configs.hasMoreElements()) {
                URL url = configs.nextElement();
                URI uri = new URI(url.toExternalForm().replace(" ", "%20"));
                ClassLoader highestClassLoader = ServiceLoader.findHighestReachableClassLoader(url, classLoader, resourceName);
                if (highestClassLoader.getClass().getName().equals(IGNORED_GLASSFISH_MAGIC_CLASSLOADER)) continue;
                urlDefinitions.add(new URLDefinition(uri, highestClassLoader));
            }
            return urlDefinitions;
        }
        catch (Exception e) {
            LOGGER.severe(e);
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ServiceDefinition> parse(URLDefinition urlDefinition) {
        try {
            HashSet<ServiceDefinition> names = new HashSet<ServiceDefinition>();
            BufferedReader r = null;
            try {
                String line;
                URL url = urlDefinition.uri.toURL();
                r = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                while ((line = r.readLine()) != null) {
                    String name;
                    int comment = line.indexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, comment);
                    }
                    if ((name = line.trim()).length() == 0) continue;
                    names.add(new ServiceDefinition(name, urlDefinition.classLoader));
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(r);
                throw throwable;
            }
            IOUtil.closeResource(r);
            return names;
        }
        catch (Exception e) {
            LOGGER.severe(e);
            return Collections.emptySet();
        }
    }

    private static ClassLoader findHighestReachableClassLoader(URL url, ClassLoader classLoader, String resourceName) {
        if (classLoader.getParent() == null) {
            return classLoader;
        }
        ClassLoader highestClassLoader = classLoader;
        ClassLoader current = classLoader;
        while (current.getParent() != null && !FILTERING_CLASS_LOADER.equals(current.getClass().getCanonicalName())) {
            ClassLoader parent = current.getParent();
            try {
                Enumeration<URL> resources = parent.getResources(resourceName);
                if (resources != null) {
                    while (resources.hasMoreElements()) {
                        URL resourceURL = resources.nextElement();
                        if (!url.toURI().equals(resourceURL.toURI())) continue;
                        highestClassLoader = parent;
                    }
                }
            }
            catch (IOException ignore) {
                EmptyStatement.ignore(ignore);
            }
            catch (URISyntaxException ignore) {
                EmptyStatement.ignore(ignore);
            }
            current = current.getParent();
        }
        return highestClassLoader;
    }

    static List<ClassLoader> selectClassLoaders(ClassLoader classLoader) {
        ClassLoader coreClassLoader;
        ClassLoader tccl;
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        if (classLoader != null) {
            classLoaders.add(classLoader);
        }
        if ((tccl = Thread.currentThread().getContextClassLoader()) != classLoader) {
            classLoaders.add(tccl);
        }
        if ((coreClassLoader = ServiceLoader.class.getClassLoader()) != classLoader && coreClassLoader != tccl) {
            classLoaders.add(coreClassLoader);
        }
        try {
            Class<?> hzClientClass = Class.forName("com.att.aft.dme2.hazelcast.client.HazelcastClient");
            ClassLoader clientClassLoader = hzClientClass.getClassLoader();
            if (clientClassLoader != classLoader && clientClassLoader != tccl && clientClassLoader != coreClassLoader) {
                classLoaders.add(clientClassLoader);
            }
        }
        catch (ClassNotFoundException ignore) {
            EmptyStatement.ignore(ignore);
        }
        return classLoaders;
    }

    private static class LoadClassIterator<T>
    implements Iterator<Class<T>> {
        final Iterator<ServiceDefinition> iterator;

        public LoadClassIterator(Set<ServiceDefinition> serviceDefinitions) {
            this.iterator = serviceDefinitions.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Class<T> next() {
            ServiceDefinition definition = this.iterator.next();
            try {
                String className = definition.className;
                ClassLoader classLoader = definition.classLoader;
                return ClassLoaderUtil.loadClass(classLoader, className);
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class NewInstanceIterator<T>
    implements Iterator<T> {
        final Iterator<ServiceDefinition> iterator;
        private final Class<T> clazz;

        public NewInstanceIterator(Set<ServiceDefinition> serviceDefinitions, Class<T> clazz) {
            this.clazz = clazz;
            this.iterator = serviceDefinitions.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            ServiceDefinition definition = this.iterator.next();
            try {
                String className = definition.className;
                ClassLoader classLoader = definition.classLoader;
                return this.clazz.cast(ClassLoaderUtil.newInstance(classLoader, className));
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class URLDefinition {
        private final URI uri;
        private final ClassLoader classLoader;

        private URLDefinition(URI url, ClassLoader classLoader) {
            this.uri = url;
            this.classLoader = classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            URLDefinition that = (URLDefinition)o;
            return !(this.uri != null ? !this.uri.equals(that.uri) : that.uri != null);
        }

        public int hashCode() {
            int result = this.uri != null ? this.uri.hashCode() : 0;
            return result;
        }
    }

    private static final class ServiceDefinition {
        private final String className;
        private final ClassLoader classLoader;

        private ServiceDefinition(String className, ClassLoader classLoader) {
            this.className = Preconditions.isNotNull(className, "className");
            this.classLoader = Preconditions.isNotNull(classLoader, "classLoader");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceDefinition that = (ServiceDefinition)o;
            if (!this.classLoader.equals(that.classLoader)) {
                return false;
            }
            return this.className.equals(that.className);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.classLoader.hashCode();
            return result;
        }
    }
}

