/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.util;

import com.att.aft.dme2.hazelcast.nio.Address;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public final class UuidUtil {
    private static final AtomicLong SEED_UNIQUIFIER = new AtomicLong(8682522807148012L);
    private static final long MOTHER_OF_MAGIC_NUMBERS = 181783497276652981L;
    private static final ThreadLocal<Random> THREAD_LOCAL_UNSECURE_RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random(UuidUtil.seedUniquifier() ^ System.nanoTime());
        }
    };
    private static final ThreadLocal<SecureRandom> THREAD_LOCAL_SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };

    private UuidUtil() {
    }

    public static String createClusterUuid() {
        return UuidUtil.newUnsecureUuidString();
    }

    public static String createMemberUuid(Address endpoint) {
        return UuidUtil.newUnsecureUuidString();
    }

    public static String createClientUuid(Address endpoint) {
        return UuidUtil.newUnsecureUuidString();
    }

    public static String newUnsecureUuidString() {
        return UuidUtil.newUnsecureUUID().toString();
    }

    public static String newSecureUuidString() {
        return UuidUtil.newSecureUUID().toString();
    }

    public static UUID newUnsecureUUID() {
        return UuidUtil.getUUID(THREAD_LOCAL_UNSECURE_RANDOM.get());
    }

    public static UUID newSecureUUID() {
        return UuidUtil.getUUID(THREAD_LOCAL_SECURE_RANDOM.get());
    }

    private static UUID getUUID(Random random) {
        int i;
        byte[] data = new byte[16];
        random.nextBytes(data);
        data[6] = (byte)(data[6] & 0xF);
        data[6] = (byte)(data[6] | 0x40);
        data[8] = (byte)(data[8] & 0x3F);
        data[8] = (byte)(data[8] | 0x80);
        long mostSigBits = 0L;
        long leastSigBits = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(mostSigBits, leastSigBits);
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!SEED_UNIQUIFIER.compareAndSet(current = SEED_UNIQUIFIER.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }
}

