/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.wan.impl;

import com.att.aft.dme2.hazelcast.config.WanPublisherConfig;
import com.att.aft.dme2.hazelcast.config.WanReplicationConfig;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.monitor.LocalWanStats;
import com.att.aft.dme2.hazelcast.nio.ClassLoaderUtil;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.wan.WanReplicationEndpoint;
import com.att.aft.dme2.hazelcast.wan.WanReplicationPublisher;
import com.att.aft.dme2.hazelcast.wan.WanReplicationService;
import com.att.aft.dme2.hazelcast.wan.impl.WanReplicationPublisherDelegate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WanReplicationServiceImpl
implements WanReplicationService {
    private final Node node;
    private final ILogger logger;
    private final Map<String, WanReplicationPublisherDelegate> wanReplications = this.initializeWanReplicationPublisherMapping();

    public WanReplicationServiceImpl(Node node) {
        this.node = node;
        this.logger = node.getLogger(WanReplicationServiceImpl.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WanReplicationPublisher getWanReplicationPublisher(String name) {
        WanReplicationPublisherDelegate wr = this.wanReplications.get(name);
        if (wr != null) {
            return wr;
        }
        WanReplicationServiceImpl wanReplicationServiceImpl = this;
        synchronized (wanReplicationServiceImpl) {
            wr = this.wanReplications.get(name);
            if (wr != null) {
                return wr;
            }
            WanReplicationConfig wanReplicationConfig = this.node.getConfig().getWanReplicationConfig(name);
            if (wanReplicationConfig == null) {
                return null;
            }
            List<WanPublisherConfig> publisherConfigs = wanReplicationConfig.getWanPublisherConfigs();
            WanReplicationEndpoint[] targetEndpoints = new WanReplicationEndpoint[publisherConfigs.size()];
            int count = 0;
            for (WanPublisherConfig publisherConfig : publisherConfigs) {
                WanReplicationEndpoint target;
                try {
                    target = publisherConfig.getImplementation() != null ? (WanReplicationEndpoint)publisherConfig.getImplementation() : (WanReplicationEndpoint)ClassLoaderUtil.newInstance(this.node.getConfigClassLoader(), publisherConfig.getClassName());
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
                target.init(this.node, wanReplicationConfig, publisherConfig);
                targetEndpoints[count++] = target;
            }
            wr = new WanReplicationPublisherDelegate(name, targetEndpoints);
            this.wanReplications.put(name, wr);
            return wr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        WanReplicationServiceImpl wanReplicationServiceImpl = this;
        synchronized (wanReplicationServiceImpl) {
            for (WanReplicationPublisherDelegate wanReplication : this.wanReplications.values()) {
                WanReplicationEndpoint[] wanReplicationEndpoints = wanReplication.getEndpoints();
                if (wanReplicationEndpoints == null) continue;
                for (WanReplicationEndpoint wanReplicationEndpoint : wanReplicationEndpoints) {
                    if (wanReplicationEndpoint == null) continue;
                    wanReplicationEndpoint.shutdown();
                }
            }
            this.wanReplications.clear();
        }
    }

    @Override
    public void pause(String name, String targetGroupName) {
        throw new UnsupportedOperationException("Pausing wan replication is not supported.");
    }

    @Override
    public void resume(String name, String targetGroupName) {
        throw new UnsupportedOperationException("Resuming wan replication is not supported");
    }

    @Override
    public void checkWanReplicationQueues(String name) {
    }

    @Override
    public void syncMap(String wanReplicationName, String targetGroupName, String mapName) {
        throw new UnsupportedOperationException("WAN sync for map is not supported.");
    }

    private ConcurrentHashMap<String, WanReplicationPublisherDelegate> initializeWanReplicationPublisherMapping() {
        return new ConcurrentHashMap<String, WanReplicationPublisherDelegate>(2);
    }

    public Map<String, LocalWanStats> getStats() {
        return null;
    }
}

