/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.apache.commons.beanutils;

import com.att.aft.dme2.internal.apache.commons.beanutils.IntrospectionContext;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultIntrospectionContext
implements IntrospectionContext {
    private static final PropertyDescriptor[] EMPTY_DESCRIPTORS = new PropertyDescriptor[0];
    private final Class<?> currentClass;
    private final Map<String, PropertyDescriptor> descriptors;

    public DefaultIntrospectionContext(Class<?> cls) {
        this.currentClass = cls;
        this.descriptors = new HashMap<String, PropertyDescriptor>();
    }

    @Override
    public Class<?> getTargetClass() {
        return this.currentClass;
    }

    @Override
    public void addPropertyDescriptor(PropertyDescriptor desc) {
        if (desc == null) {
            throw new IllegalArgumentException("Property descriptor must not be null!");
        }
        this.descriptors.put(desc.getName(), desc);
    }

    @Override
    public void addPropertyDescriptors(PropertyDescriptor[] descs) {
        if (descs == null) {
            throw new IllegalArgumentException("Array with descriptors must not be null!");
        }
        for (int i = 0; i < descs.length; ++i) {
            this.addPropertyDescriptor(descs[i]);
        }
    }

    @Override
    public boolean hasProperty(String name) {
        return this.descriptors.containsKey(name);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.descriptors.get(name);
    }

    @Override
    public void removePropertyDescriptor(String name) {
        this.descriptors.remove(name);
    }

    @Override
    public Set<String> propertyNames() {
        return this.descriptors.keySet();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors.values().toArray(EMPTY_DESCRIPTORS);
    }
}

