/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jackson.map.ser.std;

import com.att.aft.dme2.internal.jackson.JsonGenerationException;
import com.att.aft.dme2.internal.jackson.JsonGenerator;
import com.att.aft.dme2.internal.jackson.JsonNode;
import com.att.aft.dme2.internal.jackson.io.SerializedString;
import com.att.aft.dme2.internal.jackson.map.AnnotationIntrospector;
import com.att.aft.dme2.internal.jackson.map.SerializationConfig;
import com.att.aft.dme2.internal.jackson.map.SerializerProvider;
import com.att.aft.dme2.internal.jackson.map.annotate.JacksonStdImpl;
import com.att.aft.dme2.internal.jackson.map.introspect.BasicBeanDescription;
import com.att.aft.dme2.internal.jackson.map.ser.std.ScalarSerializerBase;
import com.att.aft.dme2.internal.jackson.map.util.EnumValues;
import com.att.aft.dme2.internal.jackson.node.ArrayNode;
import com.att.aft.dme2.internal.jackson.node.ObjectNode;
import com.att.aft.dme2.internal.jackson.type.JavaType;
import java.io.IOException;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class EnumSerializer
extends ScalarSerializerBase<Enum<?>> {
    protected final EnumValues _values;

    public EnumSerializer(EnumValues v) {
        super(Enum.class, false);
        this._values = v;
    }

    public static EnumSerializer construct(Class<Enum<?>> enumClass, SerializationConfig config, BasicBeanDescription beanDesc) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        EnumValues v = config.isEnabled(SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING) ? EnumValues.constructFromToString(enumClass, intr) : EnumValues.constructFromName(enumClass, intr);
        return new EnumSerializer(v);
    }

    @Override
    public final void serialize(Enum<?> en, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (provider.isEnabled(SerializationConfig.Feature.WRITE_ENUMS_USING_INDEX)) {
            jgen.writeNumber(en.ordinal());
            return;
        }
        jgen.writeString(this._values.serializedValueFor(en));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        JavaType type;
        if (provider.isEnabled(SerializationConfig.Feature.WRITE_ENUMS_USING_INDEX)) {
            return this.createSchemaNode("integer", true);
        }
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (typeHint != null && (type = provider.constructType(typeHint)).isEnumType()) {
            ArrayNode enumNode = objectNode.putArray("enum");
            for (SerializedString value : this._values.values()) {
                enumNode.add(value.getValue());
            }
        }
        return objectNode;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }
}

