/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jackson.node;

import com.att.aft.dme2.internal.jackson.JsonGenerator;
import com.att.aft.dme2.internal.jackson.JsonParser;
import com.att.aft.dme2.internal.jackson.JsonProcessingException;
import com.att.aft.dme2.internal.jackson.JsonToken;
import com.att.aft.dme2.internal.jackson.map.SerializerProvider;
import com.att.aft.dme2.internal.jackson.node.NumericNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class DecimalNode
extends NumericNode {
    protected final BigDecimal _value;

    public DecimalNode(BigDecimal v) {
        this._value = v;
    }

    public static DecimalNode valueOf(BigDecimal d) {
        return new DecimalNode(d);
    }

    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    public JsonParser.NumberType getNumberType() {
        return JsonParser.NumberType.BIG_DECIMAL;
    }

    public boolean isFloatingPointNumber() {
        return true;
    }

    public boolean isBigDecimal() {
        return true;
    }

    public Number getNumberValue() {
        return this._value;
    }

    public int getIntValue() {
        return this._value.intValue();
    }

    public long getLongValue() {
        return this._value.longValue();
    }

    public BigInteger getBigIntegerValue() {
        return this._value.toBigInteger();
    }

    public double getDoubleValue() {
        return this._value.doubleValue();
    }

    public BigDecimal getDecimalValue() {
        return this._value;
    }

    public String asText() {
        return this._value.toString();
    }

    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeNumber(this._value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((DecimalNode)o)._value.equals(this._value);
    }

    public int hashCode() {
        return this._value.hashCode();
    }
}

