/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jackson.node;

import com.att.aft.dme2.internal.jackson.JsonGenerator;
import com.att.aft.dme2.internal.jackson.JsonParser;
import com.att.aft.dme2.internal.jackson.JsonProcessingException;
import com.att.aft.dme2.internal.jackson.JsonToken;
import com.att.aft.dme2.internal.jackson.io.NumberOutput;
import com.att.aft.dme2.internal.jackson.map.SerializerProvider;
import com.att.aft.dme2.internal.jackson.node.NumericNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class DoubleNode
extends NumericNode {
    protected final double _value;

    public DoubleNode(double v) {
        this._value = v;
    }

    public static DoubleNode valueOf(double v) {
        return new DoubleNode(v);
    }

    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    public JsonParser.NumberType getNumberType() {
        return JsonParser.NumberType.DOUBLE;
    }

    public boolean isFloatingPointNumber() {
        return true;
    }

    public boolean isDouble() {
        return true;
    }

    public Number getNumberValue() {
        return this._value;
    }

    public int getIntValue() {
        return (int)this._value;
    }

    public long getLongValue() {
        return (long)this._value;
    }

    public double getDoubleValue() {
        return this._value;
    }

    public BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    public BigInteger getBigIntegerValue() {
        return this.getDecimalValue().toBigInteger();
    }

    public String asText() {
        return NumberOutput.toString(this._value);
    }

    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeNumber(this._value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((DoubleNode)o)._value == this._value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this._value);
        return (int)l ^ (int)(l >> 32);
    }
}

