/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jackson.node;

import com.att.aft.dme2.internal.jackson.node.ArrayNode;
import com.att.aft.dme2.internal.jackson.node.BigIntegerNode;
import com.att.aft.dme2.internal.jackson.node.BinaryNode;
import com.att.aft.dme2.internal.jackson.node.BooleanNode;
import com.att.aft.dme2.internal.jackson.node.DecimalNode;
import com.att.aft.dme2.internal.jackson.node.DoubleNode;
import com.att.aft.dme2.internal.jackson.node.IntNode;
import com.att.aft.dme2.internal.jackson.node.LongNode;
import com.att.aft.dme2.internal.jackson.node.NullNode;
import com.att.aft.dme2.internal.jackson.node.NumericNode;
import com.att.aft.dme2.internal.jackson.node.ObjectNode;
import com.att.aft.dme2.internal.jackson.node.POJONode;
import com.att.aft.dme2.internal.jackson.node.TextNode;
import com.att.aft.dme2.internal.jackson.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory {
    public static final JsonNodeFactory instance = new JsonNodeFactory();

    protected JsonNodeFactory() {
    }

    public BooleanNode booleanNode(boolean v) {
        return v ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public NumericNode numberNode(byte v) {
        return IntNode.valueOf(v);
    }

    public ValueNode numberNode(Byte value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value.intValue());
    }

    public NumericNode numberNode(short v) {
        return IntNode.valueOf(v);
    }

    public ValueNode numberNode(Short value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value.shortValue());
    }

    public NumericNode numberNode(int v) {
        return IntNode.valueOf(v);
    }

    public ValueNode numberNode(Integer value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value);
    }

    public NumericNode numberNode(long v) {
        return LongNode.valueOf(v);
    }

    public ValueNode numberNode(Long value) {
        return value == null ? this.nullNode() : LongNode.valueOf(value);
    }

    public NumericNode numberNode(BigInteger v) {
        return BigIntegerNode.valueOf(v);
    }

    public NumericNode numberNode(float v) {
        return DoubleNode.valueOf(v);
    }

    public ValueNode numberNode(Float value) {
        return value == null ? this.nullNode() : DoubleNode.valueOf(value.doubleValue());
    }

    public NumericNode numberNode(double v) {
        return DoubleNode.valueOf(v);
    }

    public ValueNode numberNode(Double value) {
        return value == null ? this.nullNode() : DoubleNode.valueOf(value);
    }

    public NumericNode numberNode(BigDecimal v) {
        return DecimalNode.valueOf(v);
    }

    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    public BinaryNode binaryNode(byte[] data, int offset, int length) {
        return BinaryNode.valueOf(data, offset, length);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public POJONode POJONode(Object pojo) {
        return new POJONode(pojo);
    }
}

