/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.client;

import com.att.aft.dme2.internal.jetty.client.HttpContentResponse;
import com.att.aft.dme2.internal.jetty.client.HttpConversation;
import com.att.aft.dme2.internal.jetty.client.HttpExchange;
import com.att.aft.dme2.internal.jetty.client.HttpRequest;
import com.att.aft.dme2.internal.jetty.client.HttpRequestException;
import com.att.aft.dme2.internal.jetty.client.ProtocolHandler;
import com.att.aft.dme2.internal.jetty.client.ResponseNotifier;
import com.att.aft.dme2.internal.jetty.client.api.Request;
import com.att.aft.dme2.internal.jetty.client.api.Response;
import com.att.aft.dme2.internal.jetty.client.api.Result;
import com.att.aft.dme2.internal.jetty.client.util.BufferingResponseListener;
import com.att.aft.dme2.internal.jetty.http.HttpHeader;
import com.att.aft.dme2.internal.jetty.http.HttpHeaderValue;
import java.util.List;

public class ContinueProtocolHandler
implements ProtocolHandler {
    public static final String NAME = "continue";
    private static final String ATTRIBUTE = ContinueProtocolHandler.class.getName() + ".100continue";
    private final ResponseNotifier notifier = new ResponseNotifier();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        boolean expect100 = request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        HttpConversation conversation = ((HttpRequest)request).getConversation();
        boolean handled100 = conversation.getAttribute(ATTRIBUTE) != null;
        return expect100 && !handled100;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new ContinueListener();
    }

    protected class ContinueListener
    extends BufferingResponseListener {
        protected ContinueListener() {
        }

        @Override
        public void onSuccess(Response response) {
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange.getResponse() == response);
            switch (response.getStatus()) {
                case 100: {
                    exchange.resetResponse();
                    exchange.proceed(null);
                    break;
                }
                default: {
                    List<Response.ResponseListener> listeners = exchange.getResponseListeners();
                    HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                    ContinueProtocolHandler.this.notifier.forwardSuccess(listeners, contentResponse);
                    exchange.proceed(new HttpRequestException("Expectation failed", exchange.getRequest()));
                    break;
                }
            }
        }

        @Override
        public void onFailure(Response response, Throwable failure) {
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange.getResponse() == response);
            List<Response.ResponseListener> listeners = exchange.getResponseListeners();
            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
            ContinueProtocolHandler.this.notifier.forwardFailureComplete(listeners, exchange.getRequest(), exchange.getRequestFailure(), contentResponse, failure);
        }

        @Override
        public void onComplete(Result result) {
        }
    }
}

