/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.io;

import com.att.aft.dme2.internal.jetty.io.AbstractEndPoint;
import com.att.aft.dme2.internal.jetty.io.EofException;
import com.att.aft.dme2.internal.jetty.util.BufferUtil;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;

public class ChannelEndPoint
extends AbstractEndPoint {
    private static final Logger LOG = Log.getLogger(ChannelEndPoint.class);
    private final SocketChannel _channel;
    private final Socket _socket;
    private volatile boolean _ishut;
    private volatile boolean _oshut;

    public ChannelEndPoint(Scheduler scheduler, SocketChannel channel) {
        super(scheduler, (InetSocketAddress)channel.socket().getLocalSocketAddress(), (InetSocketAddress)channel.socket().getRemoteSocketAddress());
        this._channel = channel;
        this._socket = channel.socket();
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    protected void shutdownInput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ishut {}", this);
        }
        this._ishut = true;
        if (this._oshut) {
            this.close();
        }
    }

    @Override
    public void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("oshut {}", this);
        }
        this._oshut = true;
        if (this._channel.isOpen()) {
            try {
                if (!this._socket.isOutputShutdown()) {
                    this._socket.shutdownOutput();
                }
            }
            catch (IOException e) {
                LOG.debug(e);
            }
            finally {
                if (this._ishut) {
                    this.close();
                }
            }
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this._oshut || !this._channel.isOpen() || this._socket.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this._ishut || !this._channel.isOpen() || this._socket.isInputShutdown();
    }

    @Override
    public void close() {
        super.close();
        if (LOG.isDebugEnabled()) {
            LOG.debug("close {}", this);
        }
        try {
            this._channel.close();
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        finally {
            this._ishut = true;
            this._oshut = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        if (this._ishut) {
            return -1;
        }
        int pos = BufferUtil.flipToFill(buffer);
        try {
            int filled = this._channel.read(buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("filled {} {}", filled, this);
            }
            if (filled > 0) {
                this.notIdle();
            } else if (filled == -1) {
                this.shutdownInput();
            }
            int n = filled;
            return n;
        }
        catch (IOException e) {
            LOG.debug(e);
            this.shutdownInput();
            int n = -1;
            return n;
        }
        finally {
            BufferUtil.flipToFlush(buffer, pos);
        }
    }

    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        long flushed = 0L;
        try {
            if (buffers.length == 1) {
                flushed = this._channel.write(buffers[0]);
            } else if (buffers.length > 1) {
                flushed = this._channel.write(buffers, 0, buffers.length);
            } else {
                for (ByteBuffer b : buffers) {
                    if (!b.hasRemaining()) continue;
                    int l = this._channel.write(b);
                    if (l > 0) {
                        flushed += (long)l;
                    }
                    if (b.hasRemaining()) break;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} {}", flushed, this);
            }
        }
        catch (IOException e) {
            throw new EofException(e);
        }
        if (flushed > 0L) {
            this.notIdle();
        }
        for (ByteBuffer b : buffers) {
            if (BufferUtil.isEmpty(b)) continue;
            return false;
        }
        return true;
    }

    public ByteChannel getChannel() {
        return this._channel;
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    public Socket getSocket() {
        return this._socket;
    }

    @Override
    protected void onIncompleteFlush() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void needsFillInterest() throws IOException {
        throw new UnsupportedOperationException();
    }
}

