/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.plus.webapp;

import com.att.aft.dme2.internal.jetty.plus.jndi.Transaction;
import com.att.aft.dme2.internal.jetty.plus.webapp.PlusDecorator;
import com.att.aft.dme2.internal.jetty.plus.webapp.PlusDescriptorProcessor;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.webapp.AbstractConfiguration;
import com.att.aft.dme2.internal.jetty.webapp.WebAppContext;
import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;

public class PlusConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(PlusConfiguration.class);
    private Integer _key;

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new PlusDecorator(context));
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new PlusDecorator(context));
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        context.getMetaData().addDescriptorProcessor(new PlusDescriptorProcessor());
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        this.lockCompEnv(context);
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        this.unlockCompEnv(context);
        this._key = null;
        context.setAttribute("com.att.aft.dme2.internal.jetty.injectionCollection", null);
        context.setAttribute("com.att.aft.dme2.internal.jetty.lifecyleCallbackCollection", null);
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            LOG.debug("No Transaction manager found - if your webapp requires one, please configure one.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockCompEnv(WebAppContext wac) throws Exception {
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            Random random = new Random();
            this._key = new Integer(random.nextInt());
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("com.att.aft.dme2.internal.jetty.jndi.lock", this._key);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        if (this._key != null) {
            ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(wac.getClassLoader());
            try {
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("com.att.aft.dme2.internal.jetty.jndi.unlock", this._key);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old_loader);
            }
        }
    }
}

