/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.security;

import com.att.aft.dme2.internal.jetty.security.Authenticator;
import com.att.aft.dme2.internal.jetty.security.IdentityService;
import com.att.aft.dme2.internal.jetty.security.LoginService;
import com.att.aft.dme2.internal.jetty.security.authentication.BasicAuthenticator;
import com.att.aft.dme2.internal.jetty.security.authentication.ClientCertAuthenticator;
import com.att.aft.dme2.internal.jetty.security.authentication.DigestAuthenticator;
import com.att.aft.dme2.internal.jetty.security.authentication.FormAuthenticator;
import com.att.aft.dme2.internal.jetty.security.authentication.LoginAuthenticator;
import com.att.aft.dme2.internal.jetty.security.authentication.SpnegoAuthenticator;
import com.att.aft.dme2.internal.jetty.server.Server;
import javax.servlet.ServletContext;

public class DefaultAuthenticatorFactory
implements Authenticator.Factory {
    LoginService _loginService;

    @Override
    public Authenticator getAuthenticator(Server server, ServletContext context, Authenticator.AuthConfiguration configuration, IdentityService identityService, LoginService loginService) {
        String auth = configuration.getAuthMethod();
        LoginAuthenticator authenticator = null;
        if (auth == null || "BASIC".equalsIgnoreCase(auth)) {
            authenticator = new BasicAuthenticator();
        } else if ("DIGEST".equalsIgnoreCase(auth)) {
            authenticator = new DigestAuthenticator();
        } else if ("FORM".equalsIgnoreCase(auth)) {
            authenticator = new FormAuthenticator();
        } else if ("SPNEGO".equalsIgnoreCase(auth)) {
            authenticator = new SpnegoAuthenticator();
        } else if ("NEGOTIATE".equalsIgnoreCase(auth)) {
            authenticator = new SpnegoAuthenticator("NEGOTIATE");
        }
        if ("CLIENT_CERT".equalsIgnoreCase(auth) || "CLIENT-CERT".equalsIgnoreCase(auth)) {
            authenticator = new ClientCertAuthenticator();
        }
        return authenticator;
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        this._loginService = loginService;
    }
}

