/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.server;

import com.att.aft.dme2.internal.jetty.util.TypeUtil;
import com.att.aft.dme2.internal.jetty.util.component.ContainerLifeCycle;
import com.att.aft.dme2.internal.jetty.util.component.Dumpable;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Collections;

public class ClassLoaderDump
implements Dumpable {
    final ClassLoader _loader;

    public ClassLoaderDump(ClassLoader loader) {
        this._loader = loader;
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        if (this._loader == null) {
            out.append("No ClassLoader\n");
        } else {
            out.append(String.valueOf(this._loader)).append("\n");
            ClassLoader parent = this._loader.getParent();
            if (parent != null) {
                if (this._loader instanceof URLClassLoader) {
                    ContainerLifeCycle.dump(out, indent, TypeUtil.asList(((URLClassLoader)this._loader).getURLs()), Collections.singleton(parent.toString()));
                } else {
                    ContainerLifeCycle.dump(out, indent, Collections.singleton(parent.toString()));
                }
            }
        }
    }
}

