/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.server;

import com.att.aft.dme2.internal.jetty.util.StringUtil;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class HomeBaseWarning {
    private static final Logger LOG = Log.getLogger(HomeBaseWarning.class);

    public HomeBaseWarning() {
        boolean showWarn = false;
        String home = System.getProperty("jetty.home");
        String base = System.getProperty("jetty.base");
        if (StringUtil.isBlank(base)) {
            return;
        }
        Path homePath = new File(home).toPath();
        Path basePath = new File(base).toPath();
        try {
            showWarn = Files.isSameFile(homePath, basePath);
        }
        catch (IOException e) {
            LOG.ignore(e);
            return;
        }
        if (showWarn) {
            StringBuilder warn = new StringBuilder();
            warn.append("This instance of Jetty is not running from a separate {jetty.base} directory");
            warn.append(", this is not recommended.  See documentation at http://www.eclipse.org/jetty/documentation/current/startup.html");
            LOG.warn("{}", warn.toString());
        }
    }
}

