/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.server;

import com.att.aft.dme2.internal.jetty.http.HttpContent;
import com.att.aft.dme2.internal.jetty.http.MimeTypes;
import com.att.aft.dme2.internal.jetty.http.ResourceHttpContent;
import com.att.aft.dme2.internal.jetty.util.resource.Resource;
import com.att.aft.dme2.internal.jetty.util.resource.ResourceFactory;
import java.io.IOException;

public class ResourceContentFactory
implements HttpContent.Factory {
    private final ResourceFactory _factory;
    private final MimeTypes _mimeTypes;
    private final boolean _gzip;

    public ResourceContentFactory(ResourceFactory factory, MimeTypes mimeTypes, boolean gzip) {
        this._factory = factory;
        this._mimeTypes = mimeTypes;
        this._gzip = gzip;
    }

    @Override
    public HttpContent getContent(String pathInContext, int maxBufferSize) throws IOException {
        Resource resource = this._factory.getResource(pathInContext);
        HttpContent loaded = this.load(pathInContext, resource, maxBufferSize);
        return loaded;
    }

    private HttpContent load(String pathInContext, Resource resource, int maxBufferSize) throws IOException {
        String pathInContextGz;
        Resource resourceGz;
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (resource.isDirectory()) {
            return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), maxBufferSize);
        }
        String mt = this._mimeTypes.getMimeByExtension(pathInContext);
        if (this._gzip && (resourceGz = this._factory.getResource(pathInContextGz = pathInContext + ".gz")).exists() && resourceGz.lastModified() >= resource.lastModified() && resourceGz.length() < resource.length()) {
            return new ResourceHttpContent(resource, mt, maxBufferSize, new ResourceHttpContent(resourceGz, this._mimeTypes.getMimeByExtension(pathInContextGz), maxBufferSize));
        }
        return new ResourceHttpContent(resource, mt, maxBufferSize);
    }

    public String toString() {
        return "ResourceContentFactory[" + this._factory + "]@" + this.hashCode();
    }
}

