/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.client.io;

import com.att.aft.dme2.internal.jetty.util.FuturePromise;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.api.Session;
import com.att.aft.dme2.internal.jetty.websocket.client.ClientUpgradeRequest;
import com.att.aft.dme2.internal.jetty.websocket.client.ClientUpgradeResponse;
import com.att.aft.dme2.internal.jetty.websocket.client.WebSocketClient;
import com.att.aft.dme2.internal.jetty.websocket.client.io.UpgradeListener;
import com.att.aft.dme2.internal.jetty.websocket.client.masks.Masker;
import com.att.aft.dme2.internal.jetty.websocket.common.WebSocketSession;
import com.att.aft.dme2.internal.jetty.websocket.common.events.EventDriver;

public abstract class ConnectPromise
extends FuturePromise<Session>
implements Runnable {
    private static final Logger LOG = Log.getLogger(ConnectPromise.class);
    private final WebSocketClient client;
    private final EventDriver driver;
    private final ClientUpgradeRequest request;
    private final Masker masker;
    private UpgradeListener upgradeListener;
    private ClientUpgradeResponse response;
    private WebSocketSession session;

    public ConnectPromise(WebSocketClient client, EventDriver driver, ClientUpgradeRequest request) {
        this.client = client;
        this.driver = driver;
        this.request = request;
        this.masker = client.getMasker();
    }

    @Override
    public void failed(Throwable cause) {
        this.driver.onError(cause);
        super.failed(cause);
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    public EventDriver getDriver() {
        return this.driver;
    }

    public Masker getMasker() {
        return this.masker;
    }

    public ClientUpgradeRequest getRequest() {
        return this.request;
    }

    public ClientUpgradeResponse getResponse() {
        return this.response;
    }

    public UpgradeListener getUpgradeListener() {
        return this.upgradeListener;
    }

    public void setResponse(ClientUpgradeResponse response) {
        this.response = response;
    }

    public void setUpgradeListener(UpgradeListener upgradeListener) {
        this.upgradeListener = upgradeListener;
    }

    public void succeeded() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.succeeded()", this.getClass().getSimpleName());
        }
        this.session.setUpgradeRequest(this.request);
        this.session.setUpgradeResponse(this.response);
        super.succeeded(this.session);
    }

    public void setSession(WebSocketSession session) {
        this.session = session;
    }
}

