/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.client.io;

import com.att.aft.dme2.internal.jetty.io.EndPoint;
import com.att.aft.dme2.internal.jetty.websocket.api.BatchMode;
import com.att.aft.dme2.internal.jetty.websocket.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.api.WriteCallback;
import com.att.aft.dme2.internal.jetty.websocket.api.extensions.Frame;
import com.att.aft.dme2.internal.jetty.websocket.api.extensions.IncomingFrames;
import com.att.aft.dme2.internal.jetty.websocket.client.io.ConnectPromise;
import com.att.aft.dme2.internal.jetty.websocket.client.masks.Masker;
import com.att.aft.dme2.internal.jetty.websocket.common.WebSocketFrame;
import com.att.aft.dme2.internal.jetty.websocket.common.io.AbstractWebSocketConnection;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private final ConnectPromise connectPromise;
    private final Masker masker;
    private final AtomicBoolean opened = new AtomicBoolean(false);

    public WebSocketClientConnection(EndPoint endp, Executor executor, ConnectPromise connectPromise, WebSocketPolicy policy) {
        super(endp, executor, connectPromise.getClient().getScheduler(), policy, connectPromise.getClient().getBufferPool());
        this.connectPromise = connectPromise;
        this.masker = connectPromise.getMasker();
        assert (this.masker != null);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    @Override
    public void onOpen() {
        super.onOpen();
        boolean beenOpened = this.opened.getAndSet(true);
        if (!beenOpened) {
            this.connectPromise.succeeded();
        }
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame instanceof WebSocketFrame) {
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback, batchMode);
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

