/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.common.scopes;

import com.att.aft.dme2.internal.jetty.io.ByteBufferPool;
import com.att.aft.dme2.internal.jetty.io.MappedByteBufferPool;
import com.att.aft.dme2.internal.jetty.util.DecoratedObjectFactory;
import com.att.aft.dme2.internal.jetty.util.component.ContainerLifeCycle;
import com.att.aft.dme2.internal.jetty.util.ssl.SslContextFactory;
import com.att.aft.dme2.internal.jetty.util.thread.QueuedThreadPool;
import com.att.aft.dme2.internal.jetty.websocket.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.common.WebSocketSession;
import com.att.aft.dme2.internal.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.concurrent.Executor;

public class SimpleContainerScope
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private final ByteBufferPool bufferPool;
    private final DecoratedObjectFactory objectFactory;
    private final WebSocketPolicy policy;
    private Executor executor;
    private SslContextFactory sslContextFactory;

    public SimpleContainerScope(WebSocketPolicy policy) {
        this(policy, new MappedByteBufferPool(), new DecoratedObjectFactory());
    }

    public SimpleContainerScope(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this(policy, bufferPool, new DecoratedObjectFactory());
    }

    public SimpleContainerScope(WebSocketPolicy policy, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory) {
        this.policy = policy;
        this.bufferPool = bufferPool;
        this.objectFactory = objectFactory;
        QueuedThreadPool threadPool = new QueuedThreadPool();
        String name = "WebSocketSimpleContainer@" + this.hashCode();
        threadPool.setName(name);
        threadPool.setDaemon(true);
        this.executor = threadPool;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    public void onSessionOpened(WebSocketSession session) {
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
    }
}

