/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.api;

import com.att.aft.dme2.internal.jetty.io.ByteBufferPool;
import com.att.aft.dme2.internal.jetty.util.Callback;
import com.att.aft.dme2.internal.jetty.util.FutureCallback;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketConnection;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketException;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.core.io.IncomingFrames;
import com.att.aft.dme2.internal.jetty.websocket.core.io.OutgoingFrames;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.ExtensionConfig;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.io.IOException;

public abstract class Extension
implements OutgoingFrames,
IncomingFrames {
    private Logger LOG = Log.getLogger(this.getClass());
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;
    private ExtensionConfig config;
    private IncomingFrames nextIncomingFrames;
    private OutgoingFrames nextOutgoingFrames;
    private WebSocketConnection connection;

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ExtensionConfig getConfig() {
        return this.config;
    }

    public WebSocketConnection getConnection() {
        return this.connection;
    }

    public String getName() {
        return this.config.getName();
    }

    public IncomingFrames getNextIncomingFrames() {
        return this.nextIncomingFrames;
    }

    public OutgoingFrames getNextOutgoingFrames() {
        return this.nextOutgoingFrames;
    }

    public String getParameterizedName() {
        return this.config.getParameterizedName();
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void incoming(WebSocketException e) {
        this.nextIncoming(e);
    }

    @Override
    public void incoming(WebSocketFrame frame) {
        this.nextIncoming(frame);
    }

    public boolean isRsv1User() {
        return false;
    }

    public boolean isRsv2User() {
        return false;
    }

    public boolean isRsv3User() {
        return false;
    }

    public boolean isTextDataDecoder() {
        return false;
    }

    public void nextIncoming(WebSocketException e) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("nextIncoming({}) - {}", e, this.nextIncomingFrames);
        }
        this.nextIncomingFrames.incoming(e);
    }

    public void nextIncoming(WebSocketFrame frame) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("nextIncoming({}) - {}", frame, this.nextIncomingFrames);
        }
        this.nextIncomingFrames.incoming(frame);
    }

    public <C> void nextOutput(C context, Callback<C> callback, WebSocketFrame frame) throws IOException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("nextOutput({}) - {}", frame, this.nextOutgoingFrames);
        }
        this.nextOutgoingFrames.output(context, callback, frame);
    }

    public <C> void nextOutputNoCallback(WebSocketFrame frame) throws IOException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("nextOutput({}) - {}", frame, this.nextOutgoingFrames);
        }
        this.nextOutgoingFrames.output(null, new FutureCallback(), frame);
    }

    @Override
    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) throws IOException {
        this.nextOutput(context, callback, frame);
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void setConfig(ExtensionConfig config) {
        this.config = config;
    }

    public void setConnection(WebSocketConnection connection) {
        this.connection = connection;
    }

    public void setNextIncomingFrames(IncomingFrames nextIncomingFramesHandler) {
        this.nextIncomingFrames = nextIncomingFramesHandler;
    }

    public void setNextOutgoingFrames(OutgoingFrames nextOutgoingFramesHandler) {
        this.nextOutgoingFrames = nextOutgoingFramesHandler;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }
}

