/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.api;

import com.att.aft.dme2.internal.jetty.websocket.core.api.MessageTooLargeException;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketBehavior;

public class WebSocketPolicy {
    private boolean autoFragment = false;
    private int maxPayloadSize = 65536;
    private int maxTextMessageSize = 16384;
    private int maxBinaryMessageSize = -1;
    private int bufferSize = 65536;
    private int idleTimeout = 300000;
    private final WebSocketBehavior behavior;

    public static WebSocketPolicy newClientPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.CLIENT);
    }

    public static WebSocketPolicy newServerPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.SERVER);
    }

    public WebSocketPolicy(WebSocketBehavior behavior) {
        this.behavior = behavior;
    }

    public void assertValidBinaryMessageSize(int requestedSize) {
        if (this.maxBinaryMessageSize > 0 && requestedSize > this.maxBinaryMessageSize) {
            throw new MessageTooLargeException("Requested binary message size [" + requestedSize + "] exceeds maximum size [" + this.maxBinaryMessageSize + "]");
        }
    }

    public void assertValidPayloadLength(int payloadLength) {
        if (payloadLength > this.maxPayloadSize) {
            throw new MessageTooLargeException("Requested payload length [" + payloadLength + "] exceeds maximum size [" + this.maxPayloadSize + "]");
        }
    }

    public void assertValidTextMessageSize(int requestedSize) {
        if (this.maxTextMessageSize > 0 && requestedSize > this.maxTextMessageSize) {
            throw new MessageTooLargeException("Requested text message size [" + requestedSize + "] exceeds maximum size [" + this.maxTextMessageSize + "]");
        }
    }

    public WebSocketPolicy clonePolicy() {
        WebSocketPolicy clone = new WebSocketPolicy(this.behavior);
        clone.autoFragment = this.autoFragment;
        clone.idleTimeout = this.idleTimeout;
        clone.bufferSize = this.bufferSize;
        clone.maxPayloadSize = this.maxPayloadSize;
        clone.maxBinaryMessageSize = this.maxBinaryMessageSize;
        clone.maxTextMessageSize = this.maxTextMessageSize;
        return clone;
    }

    public WebSocketBehavior getBehavior() {
        return this.behavior;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public int getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    public boolean isAutoFragment() {
        return this.autoFragment;
    }

    public void setAutoFragment(boolean autoFragment) {
        this.autoFragment = autoFragment;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setMaxBinaryMessageSize(int maxBinaryMessageSize) {
        this.maxBinaryMessageSize = maxBinaryMessageSize;
    }

    public void setMaxPayloadSize(int maxPayloadSize) {
        if (maxPayloadSize < this.bufferSize) {
            throw new IllegalStateException("Cannot have payload size be smaller than buffer size");
        }
        this.maxPayloadSize = maxPayloadSize;
    }

    public void setMaxTextMessageSize(int maxTextMessageSize) {
        this.maxTextMessageSize = maxTextMessageSize;
    }
}

