/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.extensions.compress;

import com.att.aft.dme2.internal.jetty.util.Callback;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.core.api.Extension;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.compress.DeflateCompressionMethod;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.ExtensionConfig;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.io.IOException;
import java.nio.ByteBuffer;

public class WebkitDeflateFrameExtension
extends Extension {
    private static final Logger LOG = Log.getLogger(WebkitDeflateFrameExtension.class);
    private DeflateCompressionMethod method;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incoming(WebSocketFrame frame) {
        if (frame.isControlFrame() || !frame.isRsv1()) {
            super.incoming(frame);
            return;
        }
        LOG.debug("Decompressing Frame: {}", frame);
        ByteBuffer data = frame.getPayload();
        try {
            this.method.decompress().input(data);
            while (!this.method.decompress().isDone()) {
                ByteBuffer uncompressed = this.method.decompress().process();
                WebSocketFrame out = new WebSocketFrame(frame, uncompressed);
                if (!this.method.decompress().isDone()) {
                    out.setFin(false);
                }
                this.nextIncoming(out);
            }
            this.method.decompress().end();
        }
        finally {
            this.getBufferPool().release(data);
        }
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    @Override
    public boolean isTextDataDecoder() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) throws IOException {
        if (frame.isControlFrame()) {
            this.nextOutput(context, callback, frame);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("output({}, {}, {})", context, callback, frame);
        }
        ByteBuffer data = frame.getPayload();
        try {
            this.method.compress().input(data);
            while (!this.method.compress().isDone()) {
                ByteBuffer buf = this.method.compress().process();
                WebSocketFrame out = new WebSocketFrame(frame, buf);
                out.setRsv1(true);
                if (!this.method.compress().isDone()) {
                    out.setFin(false);
                    this.nextOutputNoCallback(out);
                    continue;
                }
                this.nextOutput(context, callback, out);
            }
            this.method.compress().end();
        }
        finally {
            this.getBufferPool().release(data);
        }
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        this.method = new DeflateCompressionMethod();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

