/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.extensions.fragment;

import com.att.aft.dme2.internal.jetty.util.Callback;
import com.att.aft.dme2.internal.jetty.websocket.core.api.Extension;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.ExtensionConfig;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FragmentExtension
extends Extension {
    private int maxLength = -1;

    @Override
    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) throws IOException {
        WebSocketFrame frag;
        if (frame.isControlFrame()) {
            this.nextOutput(context, callback, frame);
            return;
        }
        byte opcode = frame.getOpCode();
        ByteBuffer payload = frame.getPayload().slice();
        int originalLimit = payload.limit();
        int currentPosition = payload.position();
        if (this.maxLength <= 0) {
            this.nextOutput(context, callback, frame);
            return;
        }
        boolean continuation = false;
        for (int length = frame.getPayloadLength(); length > this.maxLength; length -= this.maxLength) {
            frag = new WebSocketFrame(frame);
            frag.setOpCode(opcode);
            frag.setFin(false);
            frag.setContinuation(continuation);
            payload.position(currentPosition);
            payload.limit(Math.min(payload.position() + this.maxLength, originalLimit));
            frag.setPayload(payload);
            this.nextOutputNoCallback(frag);
            opcode = 0;
            continuation = true;
            currentPosition = payload.limit();
        }
        frag = new WebSocketFrame(frame);
        frag.setOpCode(opcode);
        frag.setFin(frame.isFin());
        frag.setContinuation(continuation);
        payload.position(currentPosition);
        payload.limit(originalLimit);
        frag.setPayload(payload);
        this.nextOutput(context, callback, frag);
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        this.maxLength = config.getParameter("maxLength", this.maxLength);
    }
}

