/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux;

import com.att.aft.dme2.internal.jetty.util.BufferUtil;
import com.att.aft.dme2.internal.jetty.util.Callback;
import com.att.aft.dme2.internal.jetty.util.StringUtil;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketBehavior;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketConnection;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketException;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.MuxChannel;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.MuxException;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.MuxGenerator;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.MuxParser;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.MuxPhysicalConnectionException;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.MuxedFrame;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.add.MuxAddClient;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.add.MuxAddServer;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.op.MuxAddChannelRequest;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.op.MuxAddChannelResponse;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.op.MuxDropChannel;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.op.MuxFlowControl;
import com.att.aft.dme2.internal.jetty.websocket.core.extensions.mux.op.MuxNewChannelSlot;
import com.att.aft.dme2.internal.jetty.websocket.core.io.IncomingFrames;
import com.att.aft.dme2.internal.jetty.websocket.core.io.OutgoingFrames;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Muxer
implements IncomingFrames,
MuxParser.Listener {
    private static final int CONTROL_CHANNEL_ID = 0;
    private static final Logger LOG = Log.getLogger(Muxer.class);
    private Map<Long, MuxChannel> channels = new HashMap<Long, MuxChannel>();
    private final WebSocketPolicy policy;
    private final WebSocketConnection physicalConnection;
    private InetSocketAddress remoteAddress;
    private MuxParser parser;
    private MuxGenerator generator;
    private MuxAddServer addServer;
    private MuxAddClient addClient;
    private List<String> physicalRequestHeaders;
    private List<String> physicalResponseHeaders;

    public Muxer(WebSocketConnection connection, OutgoingFrames outgoing) {
        this.physicalConnection = connection;
        this.policy = connection.getPolicy().clonePolicy();
        this.parser = new MuxParser();
        this.parser.setEvents(this);
        this.generator = new MuxGenerator();
        this.generator.setOutgoing(outgoing);
    }

    public MuxAddClient getAddClient() {
        return this.addClient;
    }

    public MuxAddServer getAddServer() {
        return this.addServer;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void incoming(WebSocketException e) {
    }

    @Override
    public void incoming(WebSocketFrame frame) {
        this.parser.parse(frame);
    }

    public boolean isOpen() {
        return this.physicalConnection.isOpen();
    }

    public String mergeHeaders(List<String> physicalHeaders, String deltaHeaders) {
        return null;
    }

    private void mustFailPhysicalConnection(MuxPhysicalConnectionException muxe) {
        MuxDropChannel drop = muxe.getMuxDropChannel();
        LOG.warn(muxe);
        try {
            this.generator.generate(drop);
        }
        catch (IOException ioe) {
            LOG.warn("Unable to send mux DropChannel", ioe);
        }
        String reason = "Mux[MUST FAIL]" + drop.getPhrase();
        reason = StringUtil.truncate(reason, 125);
        this.physicalConnection.close(1011, reason);
    }

    @Override
    public void onMuxAddChannelRequest(MuxAddChannelRequest request) {
        if (this.policy.getBehavior() == WebSocketBehavior.CLIENT) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "AddChannelRequest not allowed per spec");
        }
        if (request.getRsv() != 0) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_REQUEST_ENCODING, "RSV Not allowed to be set");
        }
        if (request.getChannelId() == 0L) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Invalid Channel ID");
        }
        long channelId = request.getChannelId();
        MuxChannel channel = new MuxChannel(channelId, this);
        this.channels.put(channelId, channel);
        try {
            String responseHandshake;
            String requestHandshake = BufferUtil.toUTF8String(request.getHandshake());
            if (request.isDeltaEncoded()) {
                requestHandshake = this.mergeHeaders(this.physicalRequestHeaders, requestHandshake);
            }
            if (StringUtil.isNotBlank(responseHandshake = this.addServer.handshake(channel, requestHandshake))) {
                MuxAddChannelResponse response = new MuxAddChannelResponse();
                response.setChannelId(request.getChannelId());
                response.setFailed(false);
                response.setHandshake(responseHandshake);
                this.generator.generate(response);
            }
        }
        catch (Throwable t) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.BAD_REQUEST, "Unable to parse request", t);
        }
    }

    @Override
    public void onMuxAddChannelResponse(MuxAddChannelResponse response) {
        if (this.policy.getBehavior() == WebSocketBehavior.SERVER) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "AddChannelResponse not allowed per spec");
        }
        if (response.getRsv() != 0) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_RESPONSE_ENCODING, "RSV Not allowed to be set");
        }
        if (response.getChannelId() == 0L) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Invalid Channel ID");
        }
        long channelId = response.getChannelId();
        MuxChannel channel = this.channels.get(channelId);
        if (channel == null) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Unknown Channel ID");
        }
        try {
            channel.onOpen();
        }
        catch (Throwable t) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.BAD_RESPONSE, "Unable to parse response", t);
        }
    }

    @Override
    public void onMuxDropChannel(MuxDropChannel drop) {
        if (drop.getChannelId() == 0L) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Invalid Channel ID");
        }
        long channelId = drop.getChannelId();
        MuxChannel channel = this.channels.get(channelId);
        if (channel == null) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Unknown Channel ID");
        }
        String reason = "Mux " + drop.toString();
        reason = StringUtil.truncate(reason, 123);
        channel.close(1002, reason);
    }

    @Override
    public void onMuxedFrame(MuxedFrame frame) {
        MuxChannel subchannel = this.channels.get(frame.getChannelId());
        subchannel.incoming(frame);
    }

    @Override
    public void onMuxException(MuxException e) {
        if (e instanceof MuxPhysicalConnectionException) {
            this.mustFailPhysicalConnection((MuxPhysicalConnectionException)e);
        }
        LOG.warn(e);
    }

    @Override
    public void onMuxFlowControl(MuxFlowControl flow) {
        if (flow.getChannelId() == 0L) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Invalid Channel ID");
        }
        if (flow.getSendQuotaSize() > Long.MAX_VALUE) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.SEND_QUOTA_OVERFLOW, "Send Quota Overflow");
        }
        long channelId = flow.getChannelId();
        MuxChannel channel = this.channels.get(channelId);
        if (channel == null) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Unknown Channel ID");
        }
    }

    @Override
    public void onMuxNewChannelSlot(MuxNewChannelSlot slot) {
        if (this.policy.getBehavior() == WebSocketBehavior.SERVER) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "NewChannelSlot not allowed per spec");
        }
        if (slot.isFallback()) {
            if (slot.getNumberOfSlots() == 0L) {
                throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Cannot have 0 number of slots during fallback");
            }
            if (slot.getInitialSendQuota() == 0L) {
                throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Cannot have 0 initial send quota during fallback");
            }
        }
    }

    public <C> void output(C context, Callback<C> callback, long channelId, WebSocketFrame frame) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("output({}, {}, {}, {})", context, callback, channelId, frame);
        }
        this.generator.output(context, callback, channelId, frame);
    }

    public void setAddClient(MuxAddClient addClient) {
        this.addClient = addClient;
    }

    public void setAddServer(MuxAddServer addServer) {
        this.addServer = addServer;
    }

    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String toString() {
        return String.format("Muxer[subChannels.size=%d]", this.channels.size());
    }
}

