/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.io;

import com.att.aft.dme2.internal.jetty.io.AbstractConnection;
import com.att.aft.dme2.internal.jetty.io.ByteBufferPool;
import com.att.aft.dme2.internal.jetty.io.EndPoint;
import com.att.aft.dme2.internal.jetty.util.BufferUtil;
import com.att.aft.dme2.internal.jetty.util.Callback;
import com.att.aft.dme2.internal.jetty.util.FutureCallback;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.util.thread.Scheduler;
import com.att.aft.dme2.internal.jetty.websocket.core.api.BaseConnection;
import com.att.aft.dme2.internal.jetty.websocket.core.api.CloseException;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.core.io.ControlFrameBytes;
import com.att.aft.dme2.internal.jetty.websocket.core.io.DataFrameBytes;
import com.att.aft.dme2.internal.jetty.websocket.core.io.FrameBytes;
import com.att.aft.dme2.internal.jetty.websocket.core.io.FrameQueue;
import com.att.aft.dme2.internal.jetty.websocket.core.io.OutgoingFrames;
import com.att.aft.dme2.internal.jetty.websocket.core.io.WebSocketSession;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.CloseInfo;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.ConnectionState;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.ExtensionConfig;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.Generator;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.Parser;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractWebSocketConnection
extends AbstractConnection
implements BaseConnection,
BaseConnection.SuspendToken,
OutgoingFrames {
    private static final Logger LOG = Log.getLogger(AbstractWebSocketConnection.class);
    private static final Logger LOG_FRAMES = Log.getLogger("com.att.aft.dme2.internal.jetty.websocket.io.Frames");
    private final ByteBufferPool bufferPool;
    private final Scheduler scheduler;
    private final Generator generator;
    private final Parser parser;
    private final WebSocketPolicy policy;
    private final FrameQueue queue;
    private final AtomicBoolean suspendToken;
    private WebSocketSession session;
    private List<ExtensionConfig> extensions;
    private boolean flushing;
    private boolean isFilling;
    private ConnectionState connectionState;
    private final AtomicBoolean inputClosed;
    private final AtomicBoolean outputClosed;

    public AbstractWebSocketConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy policy, ByteBufferPool bufferPool) {
        super(endp, executor);
        this.policy = policy;
        this.bufferPool = bufferPool;
        this.generator = new Generator(policy, bufferPool);
        this.parser = new Parser(policy);
        this.scheduler = scheduler;
        this.extensions = new ArrayList<ExtensionConfig>();
        this.queue = new FrameQueue();
        this.suspendToken = new AtomicBoolean(false);
        this.connectionState = ConnectionState.CONNECTING;
        this.inputClosed = new AtomicBoolean(false);
        this.outputClosed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int statusCode, String reason) {
        this.enqueClose(statusCode, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C> void complete(FrameBytes<C> frameBytes) {
        FrameQueue frameQueue = this.queue;
        synchronized (frameQueue) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completed Write of {} ({} frame(s) in queue)", frameBytes, this.queue.size());
            }
            this.flushing = false;
        }
    }

    @Override
    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean onlyOutput) {
        this.connectionState = ConnectionState.CLOSED;
        EndPoint endPoint = this.getEndPoint();
        LOG.debug("Shutting down output {}", endPoint);
        endPoint.shutdownOutput();
        if (!onlyOutput) {
            LOG.debug("Closing {}", endPoint);
            endPoint.close();
        }
    }

    private void enqueClose(int statusCode, String reason) {
        CloseInfo close = new CloseInfo(statusCode, reason);
        FutureCallback nop = new FutureCallback();
        this.output(null, nop, close.asFrame());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        FrameBytes frameBytes = null;
        ByteBuffer buffer = null;
        FrameQueue frameQueue = this.queue;
        synchronized (frameQueue) {
            LOG.debug(".flush() - flushing={} - queue.size = {}", this.flushing, this.queue.size());
            if (this.flushing || this.queue.isEmpty()) {
                return;
            }
            frameBytes = (FrameBytes)this.queue.pop();
            if (!this.isOpen()) {
                this.queue.clear();
                return;
            }
            LOG.debug("Next FrameBytes: {}", frameBytes);
            buffer = frameBytes.getByteBuffer();
            if (buffer == null) {
                return;
            }
            this.flushing = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushing {}, {} frame(s) in queue", frameBytes, this.queue.size());
            }
            if (this.connectionState != ConnectionState.CLOSED) {
                this.write(buffer, frameBytes);
            }
        }
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Parser getParser() {
        return this.parser;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public FrameQueue getQueue() {
        return this.queue;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public ConnectionState getState() {
        return this.connectionState;
    }

    @Override
    public boolean isInputClosed() {
        return this.inputClosed.get();
    }

    @Override
    public boolean isOpen() {
        return this.getState() != ConnectionState.CLOSED && this.getEndPoint().isOpen();
    }

    @Override
    public boolean isOutputClosed() {
        return this.outputClosed.get();
    }

    @Override
    public boolean isReading() {
        return this.isFilling;
    }

    @Override
    public void onClose() {
        super.onClose();
        this.connectionState = ConnectionState.CLOSED;
    }

    @Override
    public void onCloseHandshake(boolean incoming, CloseInfo close) {
        boolean in = this.inputClosed.get();
        boolean out = this.outputClosed.get();
        if (incoming) {
            in = true;
            this.inputClosed.set(true);
        } else {
            out = true;
            this.outputClosed.set(true);
        }
        LOG.debug("onCloseHandshake({},{}), input={}, output={}", incoming, close, in, out);
        if (in && out) {
            LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
            this.disconnect(false);
        }
        if (close.isHarsh()) {
            LOG.debug("Close status code was harsh, disconnecting", new Object[0]);
            this.disconnect(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillable() {
        LOG.debug("{} onFillable()", new Object[]{this.policy.getBehavior()});
        ByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), false);
        BufferUtil.clear(buffer);
        boolean readMore = false;
        try {
            this.isFilling = true;
            readMore = this.read(buffer) != -1;
        }
        finally {
            this.bufferPool.release(buffer);
        }
        if (readMore && !this.suspendToken.get()) {
            this.fillInterested();
        } else {
            this.isFilling = false;
        }
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.connectionState = ConnectionState.OPEN;
        LOG.debug("fillInterested", new Object[0]);
        this.fillInterested();
    }

    @Override
    protected boolean onReadTimeout() {
        LOG.debug("Read Timeout. disconnecting connection", new Object[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("output({}, {}, {})", context, callback, frame);
        }
        FrameQueue frameQueue = this.queue;
        synchronized (frameQueue) {
            FrameBytes bytes = null;
            bytes = frame.isControlFrame() ? new ControlFrameBytes<C>(this, callback, context, frame) : new DataFrameBytes<C>(this, callback, context, frame);
            this.scheduleTimeout(bytes);
            if (this.isOpen()) {
                if (frame.getOpCode() == 9) {
                    this.queue.prepend(bytes);
                } else {
                    this.queue.append(bytes);
                }
            }
        }
        this.flush();
    }

    private int read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            while (true) {
                int filled;
                if ((filled = endPoint.fill(buffer)) == 0) {
                    return 0;
                }
                if (filled < 0) {
                    LOG.debug("read - EOF Reached", new Object[0]);
                    return -1;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes - {}", filled, BufferUtil.toDetailString(buffer));
                }
                this.parser.parse(buffer);
            }
        }
        catch (IOException e) {
            LOG.warn(e);
            this.enqueClose(1002, e.getMessage());
            return -1;
        }
        catch (CloseException e) {
            LOG.warn(e);
            this.enqueClose(e.getStatusCode(), e.getMessage());
            return -1;
        }
    }

    @Override
    public void resume() {
        if (this.suspendToken.getAndSet(false)) {
            this.fillInterested();
        }
    }

    private <C> void scheduleTimeout(FrameBytes<C> bytes) {
        if (this.policy.getIdleTimeout() > 0) {
            bytes.task = this.scheduler.schedule(bytes, this.policy.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
        this.extensions = extensions;
    }

    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    @Override
    public BaseConnection.SuspendToken suspend() {
        this.suspendToken.set(true);
        return this;
    }

    @Override
    public String toString() {
        return String.format("%s{g=%s,p=%s}", super.toString(), this.generator, this.parser);
    }

    private <C> void write(ByteBuffer buffer, FrameBytes<C> frameBytes) {
        EndPoint endpoint = this.getEndPoint();
        if (LOG_FRAMES.isDebugEnabled()) {
            LOG_FRAMES.debug("{} Writing {} frame bytes of {}", new Object[]{this.policy.getBehavior(), buffer.remaining(), frameBytes});
        }
        if (this.connectionState == ConnectionState.CLOSED) {
            return;
        }
        try {
            endpoint.write(frameBytes.context, frameBytes, new ByteBuffer[]{buffer});
        }
        catch (Throwable t) {
            frameBytes.failed(frameBytes.context, t);
        }
    }
}

