/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.io;

import com.att.aft.dme2.internal.jetty.util.Callback;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.core.io.AbstractWebSocketConnection;
import com.att.aft.dme2.internal.jetty.websocket.core.io.FrameBytes;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.nio.ByteBuffer;

public class DataFrameBytes<C>
extends FrameBytes<C> {
    private static final Logger LOG = Log.getLogger(DataFrameBytes.class);
    private ByteBuffer buffer;

    public DataFrameBytes(AbstractWebSocketConnection connection, Callback<C> callback, C context, WebSocketFrame frame) {
        super(connection, callback, context, frame);
    }

    @Override
    public void completed(C context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("completed({}) - frame.remaining() = {}", context, this.frame.remaining());
        }
        this.connection.getBufferPool().release(this.buffer);
        if (this.frame.remaining() > 0) {
            LOG.debug("More to send", new Object[0]);
            this.connection.getQueue().prepend(this);
            this.connection.complete(this);
        } else {
            LOG.debug("Send complete", new Object[0]);
            super.completed(context);
        }
        this.connection.flush();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        try {
            int windowSize = this.connection.getInputBufferSize();
            this.buffer = this.connection.getGenerator().generate(windowSize, this.frame);
            return this.buffer;
        }
        catch (Throwable x) {
            this.failed(this.context, x);
            return null;
        }
    }
}

