/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.io;

import com.att.aft.dme2.internal.jetty.io.EofException;
import com.att.aft.dme2.internal.jetty.util.Callback;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.util.thread.Scheduler;
import com.att.aft.dme2.internal.jetty.websocket.core.io.AbstractWebSocketConnection;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.nio.ByteBuffer;
import java.nio.channels.InterruptedByTimeoutException;

public abstract class FrameBytes<C>
implements Callback<C>,
Runnable {
    private static final Logger LOG = Log.getLogger(FrameBytes.class);
    protected final AbstractWebSocketConnection connection;
    protected final Callback<C> callback;
    protected final C context;
    protected final WebSocketFrame frame;
    protected volatile Scheduler.Task task;

    protected FrameBytes(AbstractWebSocketConnection connection, Callback<C> callback, C context, WebSocketFrame frame) {
        this.connection = connection;
        this.callback = callback;
        this.context = context;
        this.frame = frame;
    }

    private void cancelTask() {
        Scheduler.Task task = this.task;
        if (task != null) {
            task.cancel();
        }
    }

    public void completed(C context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("completed({}) - {}", context, this.getClass().getName());
        }
        this.cancelTask();
        this.connection.complete(this);
        this.callback.completed(context);
    }

    public void failed(C context, Throwable x) {
        if (x instanceof EofException) {
            LOG.warn("failed(" + context + ") - " + EofException.class, new Object[0]);
        } else {
            LOG.warn("failed(" + context + ")", x);
        }
        this.cancelTask();
        this.callback.failed(context, x);
    }

    public abstract ByteBuffer getByteBuffer();

    @Override
    public void run() {
        this.connection.close();
        this.failed(this.context, new InterruptedByTimeoutException());
    }

    public String toString() {
        return this.frame.toString();
    }
}

