/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.io.event;

import com.att.aft.dme2.internal.jetty.websocket.core.annotations.WebSocket;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketException;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.core.io.event.EventDriver;
import com.att.aft.dme2.internal.jetty.websocket.core.io.event.EventMethods;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.MessageAppender;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.MessageInputStream;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.MessageReader;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.SimpleBinaryMessage;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.SimpleTextMessage;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.CloseInfo;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;

public class AnnotatedEventDriver
extends EventDriver {
    private final EventMethods events;
    private MessageAppender activeMessage;

    public AnnotatedEventDriver(WebSocketPolicy policy, Object websocket, EventMethods events) {
        super(policy, websocket);
        this.events = events;
        WebSocket anno = websocket.getClass().getAnnotation(WebSocket.class);
        if (anno.maxBufferSize() > 0) {
            this.policy.setBufferSize(anno.maxBufferSize());
        }
        if (anno.maxBinarySize() > 0) {
            this.policy.setMaxBinaryMessageSize(anno.maxBinarySize());
        }
        if (anno.maxTextSize() > 0) {
            this.policy.setMaxTextMessageSize(anno.maxTextSize());
        }
        if (anno.maxIdleTime() > 0) {
            this.policy.setIdleTimeout(anno.maxIdleTime());
        }
    }

    @Override
    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.events.onBinary == null) {
            return;
        }
        if (this.activeMessage == null) {
            this.activeMessage = this.events.onBinary.isStreaming() ? new MessageInputStream(this) : new SimpleBinaryMessage(this);
        }
        this.activeMessage.appendMessage(buffer);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onBinaryMessage(byte[] data) {
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, this.session, data, 0, data.length);
        }
    }

    @Override
    public void onClose(CloseInfo close) {
        if (this.events.onClose != null) {
            this.events.onClose.call(this.websocket, this.session, close.getStatusCode(), close.getReason());
        }
    }

    @Override
    public void onConnect() {
        if (this.events.onConnect != null) {
            this.events.onConnect.call(this.websocket, this.session);
        }
    }

    @Override
    public void onException(WebSocketException e) {
        if (this.events.onException != null) {
            this.events.onException.call(this.websocket, this.session, e);
        }
    }

    @Override
    public void onFrame(WebSocketFrame frame) {
        if (this.events.onFrame != null) {
            this.events.onFrame.call(this.websocket, this.session, frame);
        }
    }

    public void onInputStream(InputStream stream) {
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, this.session, stream);
        }
    }

    public void onReader(Reader reader) {
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, this.session, reader);
        }
    }

    @Override
    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.events.onText == null) {
            return;
        }
        if (this.activeMessage == null) {
            this.activeMessage = this.events.onText.isStreaming() ? new MessageReader(this) : new SimpleTextMessage(this);
        }
        this.activeMessage.appendMessage(buffer);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onTextMessage(String message) {
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, this.session, message);
        }
    }
}

