/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.io.event;

import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketException;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketListener;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.core.io.event.EventDriver;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.MessageAppender;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.SimpleBinaryMessage;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.SimpleTextMessage;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.CloseInfo;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ListenerEventDriver
extends EventDriver {
    private final WebSocketListener listener;
    private MessageAppender activeMessage;

    public ListenerEventDriver(WebSocketPolicy policy, WebSocketListener listener) {
        super(policy, listener);
        this.listener = listener;
    }

    @Override
    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            this.activeMessage = new SimpleBinaryMessage(this);
        }
        this.activeMessage.appendMessage(buffer);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onBinaryMessage(byte[] data) {
        this.listener.onWebSocketBinary(data, 0, data.length);
    }

    @Override
    public void onClose(CloseInfo close) {
        int statusCode = close.getStatusCode();
        String reason = close.getReason();
        this.listener.onWebSocketClose(statusCode, reason);
    }

    @Override
    public void onConnect() {
        this.LOG.debug("onConnect()", new Object[0]);
        this.listener.onWebSocketConnect(this.session);
    }

    @Override
    public void onException(WebSocketException e) {
        this.listener.onWebSocketException(e);
    }

    @Override
    public void onFrame(WebSocketFrame frame) {
    }

    @Override
    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            this.activeMessage = new SimpleTextMessage(this);
        }
        this.activeMessage.appendMessage(buffer);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onTextMessage(String message) {
        this.listener.onWebSocketText(message);
    }
}

