/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.io.message;

import com.att.aft.dme2.internal.jetty.util.BufferUtil;
import com.att.aft.dme2.internal.jetty.websocket.core.io.event.EventDriver;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.MessageAppender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SimpleBinaryMessage
implements MessageAppender {
    private static final int BUFFER_SIZE = 65535;
    private final EventDriver onEvent;
    private final ByteArrayOutputStream out;
    private int size;
    private boolean finished;

    public SimpleBinaryMessage(EventDriver onEvent) {
        this.onEvent = onEvent;
        this.out = new ByteArrayOutputStream(65535);
        this.finished = false;
    }

    @Override
    public void appendMessage(ByteBuffer payload) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            return;
        }
        this.onEvent.getPolicy().assertValidBinaryMessageSize(this.size + payload.remaining());
        this.size += payload.remaining();
        BufferUtil.writeTo(payload, this.out);
    }

    @Override
    public void messageComplete() {
        this.finished = true;
        byte[] data = this.out.toByteArray();
        this.onEvent.onBinaryMessage(data);
    }
}

