/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.protocol;

import com.att.aft.dme2.internal.jetty.io.ByteBufferPool;
import com.att.aft.dme2.internal.jetty.util.BufferUtil;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.core.api.Extension;
import com.att.aft.dme2.internal.jetty.websocket.core.api.ProtocolException;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketBehavior;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.CloseInfo;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.nio.ByteBuffer;
import java.util.List;

public class Generator {
    private static final Logger LOG = Log.getLogger(Generator.class);
    public static final int OVERHEAD = 28;
    private final WebSocketBehavior behavior;
    private final ByteBufferPool bufferPool;
    private boolean validating;
    private boolean rsv1InUse = false;
    private boolean rsv2InUse = false;
    private boolean rsv3InUse = false;

    public Generator(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this(policy, bufferPool, true);
    }

    public Generator(WebSocketPolicy policy, ByteBufferPool bufferPool, boolean validating) {
        this.behavior = policy.getBehavior();
        this.bufferPool = bufferPool;
        this.validating = validating;
    }

    public void assertFrameValid(WebSocketFrame frame) {
        if (!this.validating) {
            return;
        }
        if (!this.rsv1InUse && frame.isRsv1()) {
            throw new ProtocolException("RSV1 not allowed to be set");
        }
        if (!this.rsv2InUse && frame.isRsv2()) {
            throw new ProtocolException("RSV2 not allowed to be set");
        }
        if (!this.rsv3InUse && frame.isRsv3()) {
            throw new ProtocolException("RSV3 not allowed to be set");
        }
        if (frame.isControlFrame()) {
            ByteBuffer payload;
            if (frame.getPayloadLength() > 125) {
                throw new ProtocolException("Invalid control frame payload length");
            }
            if (!frame.isFin()) {
                throw new ProtocolException("Control Frames must be FIN=true");
            }
            if (frame.getOpCode() == 8 && (payload = frame.getPayload()) != null) {
                new CloseInfo(payload, true);
            }
        }
    }

    public void configureFromExtensions(List<? extends Extension> exts) {
        this.rsv1InUse = false;
        this.rsv2InUse = false;
        this.rsv3InUse = false;
        for (Extension extension : exts) {
            if (extension.isRsv1User()) {
                this.rsv1InUse = true;
            }
            if (extension.isRsv2User()) {
                this.rsv2InUse = true;
            }
            if (!extension.isRsv3User()) continue;
            this.rsv3InUse = true;
        }
    }

    public ByteBuffer generate(int windowSize, WebSocketFrame frame) {
        if (windowSize < 28) {
            throw new IllegalArgumentException("Cannot have windowSize less than 28");
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder dbg = new StringBuilder();
            dbg.append((Object)this.behavior);
            dbg.append(" Generate.Frame[");
            dbg.append("opcode=").append(frame.getOpCode());
            dbg.append(",fin=").append(frame.isFin());
            dbg.append(",cont=").append(frame.isContinuation());
            dbg.append(",rsv1=").append(frame.isRsv1());
            dbg.append(",rsv2=").append(frame.isRsv2());
            dbg.append(",rsv3=").append(frame.isRsv3());
            dbg.append(",mask=").append(frame.isMasked());
            dbg.append(",payloadLength=").append(frame.getPayloadLength());
            dbg.append(",payloadStart=").append(frame.getPayloadStart());
            dbg.append(",remaining=").append(frame.remaining());
            dbg.append(",position=").append(frame.position());
            dbg.append(']');
            LOG.debug(dbg.toString(), new Object[0]);
        }
        ByteBuffer buffer = this.bufferPool.acquire(windowSize, true);
        BufferUtil.clearToFill(buffer);
        buffer.limit(buffer.position() + windowSize);
        if (frame.remaining() == frame.getPayloadLength()) {
            this.assertFrameValid(frame);
            byte b = 0;
            if (frame.isFin()) {
                b = (byte)(b | 0x80);
            }
            if (frame.isRsv1()) {
                b = (byte)(b | 0x40);
            }
            if (frame.isRsv2()) {
                b = (byte)(b | 0x20);
            }
            if (frame.isRsv3()) {
                b = (byte)(b | 0x10);
            }
            byte opcode = frame.getOpCode();
            if (frame.isContinuation()) {
                opcode = 0;
            }
            b = (byte)(b | opcode & 0xF);
            buffer.put(b);
            b = 0;
            b = (byte)(b | (frame.isMasked() ? 128 : 0));
            int payloadLength = frame.getPayloadLength();
            if (payloadLength > 65535) {
                b = (byte)(b | 0x7F);
                buffer.put(b);
                buffer.put((byte)0);
                buffer.put((byte)0);
                buffer.put((byte)0);
                buffer.put((byte)0);
                buffer.put((byte)(payloadLength >> 24 & 0xFF));
                buffer.put((byte)(payloadLength >> 16 & 0xFF));
                buffer.put((byte)(payloadLength >> 8 & 0xFF));
                buffer.put((byte)(payloadLength & 0xFF));
            } else if (payloadLength >= 126) {
                b = (byte)(b | 0x7E);
                buffer.put(b);
                buffer.put((byte)(payloadLength >> 8));
                buffer.put((byte)(payloadLength & 0xFF));
            } else {
                b = (byte)(b | payloadLength & 0x7F);
                buffer.put(b);
            }
            if (frame.isMasked()) {
                buffer.put(frame.getMask());
            }
        }
        if (frame.hasPayload()) {
            int maskingStartPosition = buffer.position();
            int payloadOffset = frame.getPayload().position();
            int payloadStart = frame.getPayloadStart();
            BufferUtil.put(frame.getPayload(), buffer);
            if (frame.isMasked()) {
                int size = buffer.position() - maskingStartPosition;
                byte[] mask = frame.getMask();
                for (int i = 0; i < size; ++i) {
                    int posBuf = i + maskingStartPosition;
                    int posFrame = i + (payloadOffset - payloadStart);
                    byte b = buffer.get(posBuf);
                    b = (byte)(b ^ mask[posFrame % 4]);
                    buffer.put(posBuf, b);
                }
            }
        }
        BufferUtil.flipToFlush(buffer, 0);
        return buffer;
    }

    public ByteBuffer generate(WebSocketFrame frame) {
        int bufferSize = frame.getPayloadLength() + 28;
        return this.generate(bufferSize, frame);
    }

    public boolean isRsv1InUse() {
        return this.rsv1InUse;
    }

    public boolean isRsv2InUse() {
        return this.rsv2InUse;
    }

    public boolean isRsv3InUse() {
        return this.rsv3InUse;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Generator[");
        builder.append((Object)this.behavior);
        if (this.validating) {
            builder.append(",validating");
        }
        if (this.rsv1InUse) {
            builder.append(",+rsv1");
        }
        if (this.rsv2InUse) {
            builder.append(",+rsv2");
        }
        if (this.rsv3InUse) {
            builder.append(",+rsv3");
        }
        builder.append("]");
        return builder.toString();
    }
}

