/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.protocol;

import com.att.aft.dme2.internal.jetty.util.BufferUtil;
import com.att.aft.dme2.internal.jetty.util.StringUtil;
import com.att.aft.dme2.internal.jetty.websocket.core.api.ProtocolException;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.Frame;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.OpCode;
import java.nio.ByteBuffer;

public class WebSocketFrame
implements Frame {
    public static final int MAX_CONTROL_PAYLOAD = 125;
    private boolean fin = true;
    private boolean rsv1 = false;
    private boolean rsv2 = false;
    private boolean rsv3 = false;
    private byte opcode = (byte)-1;
    private boolean masked = false;
    private byte[] mask;
    private ByteBuffer data;
    private int payloadLength = 0;
    private int payloadStart = -1;
    private boolean continuation = false;
    private int continuationIndex = 0;

    public static WebSocketFrame binary() {
        return new WebSocketFrame(2);
    }

    public static WebSocketFrame binary(byte[] buf) {
        return new WebSocketFrame(2).setPayload(buf);
    }

    public static WebSocketFrame ping() {
        return new WebSocketFrame(9);
    }

    public static WebSocketFrame pong() {
        return new WebSocketFrame(10);
    }

    public static WebSocketFrame text() {
        return new WebSocketFrame(1);
    }

    public static WebSocketFrame text(String msg) {
        return new WebSocketFrame(1).setPayload(msg);
    }

    public WebSocketFrame() {
        this(-1);
    }

    public WebSocketFrame(byte opcode) {
        this.reset();
        this.opcode = opcode;
    }

    public WebSocketFrame(WebSocketFrame copy) {
        this.fin = copy.fin;
        this.rsv1 = copy.rsv2;
        this.rsv2 = copy.rsv2;
        this.rsv3 = copy.rsv3;
        this.opcode = copy.opcode;
        this.masked = copy.masked;
        this.mask = null;
        if (copy.mask != null) {
            this.mask = new byte[copy.mask.length];
            System.arraycopy(copy.mask, 0, this.mask, 0, this.mask.length);
        }
        this.payloadLength = copy.payloadLength;
        this.payloadStart = copy.payloadStart;
        if (copy.data != null) {
            this.data = copy.data.slice();
        }
        this.continuationIndex = copy.continuationIndex;
        this.continuation = copy.continuation;
    }

    public WebSocketFrame(WebSocketFrame copy, ByteBuffer altPayload) {
        this.fin = copy.fin;
        this.rsv1 = copy.rsv2;
        this.rsv2 = copy.rsv2;
        this.rsv3 = copy.rsv3;
        this.opcode = copy.opcode;
        this.masked = copy.masked;
        this.mask = null;
        if (copy.mask != null) {
            this.mask = new byte[copy.mask.length];
            System.arraycopy(copy.mask, 0, this.mask, 0, this.mask.length);
        }
        this.continuationIndex = copy.continuationIndex;
        this.continuation = copy.continuation;
        this.setPayload(altPayload);
    }

    public void assertValid() {
        if (OpCode.isControlFrame(this.opcode)) {
            if (this.getPayloadLength() > 125) {
                throw new ProtocolException("Desired payload length [" + this.getPayloadLength() + "] exceeds maximum control payload length [" + 125 + "]");
            }
            if (!this.fin) {
                throw new ProtocolException("Cannot have FIN==false on Control frames");
            }
            if (this.rsv1) {
                throw new ProtocolException("Cannot have RSV1==true on Control frames");
            }
            if (this.rsv2) {
                throw new ProtocolException("Cannot have RSV2==true on Control frames");
            }
            if (this.rsv3) {
                throw new ProtocolException("Cannot have RSV3==true on Control frames");
            }
            if (this.isContinuation()) {
                throw new ProtocolException("Control frames cannot be Continuations");
            }
        }
    }

    public int getContinuationIndex() {
        return this.continuationIndex;
    }

    @Override
    public byte[] getMask() {
        if (!this.masked) {
            throw new IllegalStateException("Frame is not masked");
        }
        return this.mask;
    }

    @Override
    public final byte getOpCode() {
        return this.opcode;
    }

    @Override
    public ByteBuffer getPayload() {
        if (this.data != null) {
            return this.data;
        }
        return null;
    }

    public String getPayloadAsUTF8() {
        if (this.data == null) {
            return null;
        }
        return BufferUtil.toUTF8String(this.data);
    }

    @Override
    public int getPayloadLength() {
        if (this.data == null) {
            return 0;
        }
        return this.payloadLength;
    }

    public int getPayloadStart() {
        if (this.data == null) {
            return -1;
        }
        return this.payloadStart;
    }

    public boolean hasPayload() {
        return this.data != null && this.payloadLength > 0;
    }

    public boolean isContinuation() {
        return this.continuation;
    }

    public boolean isControlFrame() {
        return OpCode.isControlFrame(this.opcode);
    }

    public boolean isDataFrame() {
        return OpCode.isDataFrame(this.opcode);
    }

    @Override
    public boolean isFin() {
        return this.fin;
    }

    public boolean isLastFrame() {
        return this.fin;
    }

    @Override
    public boolean isMasked() {
        return this.masked;
    }

    @Override
    public boolean isRsv1() {
        return this.rsv1;
    }

    @Override
    public boolean isRsv2() {
        return this.rsv2;
    }

    @Override
    public boolean isRsv3() {
        return this.rsv3;
    }

    public int position() {
        if (this.data == null) {
            return -1;
        }
        return this.data.position();
    }

    public int remaining() {
        if (this.data == null) {
            return 0;
        }
        return this.data.remaining();
    }

    public void reset() {
        this.fin = true;
        this.rsv1 = false;
        this.rsv2 = false;
        this.rsv3 = false;
        this.opcode = (byte)-1;
        this.masked = false;
        this.data = null;
        this.payloadLength = 0;
        this.mask = null;
        this.continuationIndex = 0;
        this.continuation = false;
    }

    public WebSocketFrame setContinuation(boolean continuation) {
        this.continuation = continuation;
        return this;
    }

    public WebSocketFrame setContinuationIndex(int continuationIndex) {
        this.continuationIndex = continuationIndex;
        return this;
    }

    public WebSocketFrame setFin(boolean fin) {
        this.fin = fin;
        return this;
    }

    public WebSocketFrame setMask(byte[] maskingKey) {
        this.mask = maskingKey;
        this.masked = this.mask != null;
        return this;
    }

    public WebSocketFrame setMasked(boolean mask) {
        this.masked = mask;
        return this;
    }

    public WebSocketFrame setOpCode(byte op) {
        this.opcode = op;
        return this;
    }

    public WebSocketFrame setPayload(byte[] buf) {
        if (buf == null) {
            this.data = null;
            return this;
        }
        if (OpCode.isControlFrame(this.opcode) && buf.length > 125) {
            throw new ProtocolException("Control Payloads can not exceed 125 bytes in length.");
        }
        this.data = BufferUtil.toBuffer(buf);
        this.payloadStart = this.data.position();
        this.payloadLength = this.data.limit();
        return this;
    }

    public WebSocketFrame setPayload(byte[] buf, int offset, int len) {
        if (buf == null) {
            this.data = null;
            return this;
        }
        if (OpCode.isControlFrame(this.opcode) && len > 125) {
            throw new ProtocolException("Control Payloads can not exceed 125 bytes in length.");
        }
        this.data = BufferUtil.toBuffer(buf, offset, len);
        this.payloadStart = this.data.position();
        this.payloadLength = this.data.limit();
        return this;
    }

    public WebSocketFrame setPayload(ByteBuffer buf) {
        if (buf == null) {
            this.data = null;
            return this;
        }
        if (OpCode.isControlFrame(this.opcode) && buf.remaining() > 125) {
            throw new ProtocolException("Control Payloads can not exceed 125 bytes in length.");
        }
        this.data = buf.slice();
        this.payloadStart = this.data.position();
        this.payloadLength = this.data.limit();
        return this;
    }

    public WebSocketFrame setPayload(String str) {
        this.setPayload(BufferUtil.toBuffer(str, StringUtil.__UTF8_CHARSET));
        return this;
    }

    public WebSocketFrame setRsv1(boolean rsv1) {
        this.rsv1 = rsv1;
        return this;
    }

    public WebSocketFrame setRsv2(boolean rsv2) {
        this.rsv2 = rsv2;
        return this;
    }

    public WebSocketFrame setRsv3(boolean rsv3) {
        this.rsv3 = rsv3;
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(OpCode.name(this.opcode));
        b.append('[');
        b.append("len=").append(this.payloadLength);
        b.append(",fin=").append(this.fin);
        b.append(",rsv=");
        b.append(this.rsv1 ? (char)'1' : '.');
        b.append(this.rsv2 ? (char)'1' : '.');
        b.append(this.rsv3 ? (char)'1' : '.');
        b.append(",masked=").append(this.masked);
        b.append(",continuation=").append(this.continuation);
        b.append(']');
        return b.toString();
    }
}

