/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.aspectj.annotation;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import com.att.aft.dme2.internal.apache.commons.logging.LogFactory;
import com.att.aft.dme2.internal.springframework.aop.aspectj.AspectJExpressionPointcut;
import com.att.aft.dme2.internal.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import com.att.aft.dme2.internal.springframework.aop.aspectj.annotation.NotAnAtAspectException;
import com.att.aft.dme2.internal.springframework.aop.framework.AopConfigException;
import com.att.aft.dme2.internal.springframework.core.ParameterNameDiscoverer;
import com.att.aft.dme2.internal.springframework.core.annotation.AnnotationUtils;
import com.att.aft.dme2.internal.springframework.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PerClauseKind;

public abstract class AbstractAspectJAdvisorFactory
implements AspectJAdvisorFactory {
    private static final String AJC_MAGIC = "ajc$";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ParameterNameDiscoverer parameterNameDiscoverer = new AspectJAnnotationParameterNameDiscoverer();

    @Override
    public boolean isAspect(Class<?> clazz) {
        return this.hasAspectAnnotation(clazz) && !this.compiledByAjc(clazz);
    }

    private boolean hasAspectAnnotation(Class<?> clazz) {
        return AnnotationUtils.findAnnotation(clazz, Aspect.class) != null;
    }

    private boolean compiledByAjc(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().startsWith(AJC_MAGIC)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(Class<?> aspectClass) throws AopConfigException {
        if (aspectClass.getSuperclass().getAnnotation(Aspect.class) != null && !Modifier.isAbstract(aspectClass.getSuperclass().getModifiers())) {
            throw new AopConfigException("[" + aspectClass.getName() + "] cannot extend concrete aspect [" + aspectClass.getSuperclass().getName() + "]");
        }
        AjType ajType = AjTypeSystem.getAjType(aspectClass);
        if (!ajType.isAspect()) {
            throw new NotAnAtAspectException(aspectClass);
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOW) {
            throw new AopConfigException(aspectClass.getName() + " uses percflow instantiation model: This is not supported in Spring AOP.");
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOWBELOW) {
            throw new AopConfigException(aspectClass.getName() + " uses percflowbelow instantiation model: This is not supported in Spring AOP.");
        }
    }

    protected AspectJExpressionPointcut createPointcutExpression(Method annotatedMethod, Class<?> declarationScope, String[] pointcutParameterNames) {
        Class[] pointcutParameterTypes = new Class[]{};
        if (pointcutParameterNames != null) {
            pointcutParameterTypes = this.extractPointcutParameterTypes(pointcutParameterNames, annotatedMethod);
        }
        AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut(declarationScope, pointcutParameterNames, pointcutParameterTypes);
        ajexp.setLocation(annotatedMethod.toString());
        return ajexp;
    }

    private Class<?>[] extractPointcutParameterTypes(String[] argNames, Method adviceMethod) {
        Class[] ret = new Class[argNames.length];
        Class<?>[] paramTypes = adviceMethod.getParameterTypes();
        if (argNames.length > paramTypes.length) {
            throw new IllegalStateException("Expecting at least " + argNames.length + " arguments in the advice declaration, but only found " + paramTypes.length);
        }
        int typeOffset = paramTypes.length - argNames.length;
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = paramTypes[i + typeOffset];
        }
        return ret;
    }

    protected static AspectJAnnotation<?> findAspectJAnnotationOnMethod(Method method) {
        Class[] classesToLookFor;
        for (Class c : classesToLookFor = new Class[]{Before.class, Around.class, After.class, AfterReturning.class, AfterThrowing.class, Pointcut.class}) {
            AspectJAnnotation foundAnnotation = AbstractAspectJAdvisorFactory.findAnnotation(method, c);
            if (foundAnnotation == null) continue;
            return foundAnnotation;
        }
        return null;
    }

    private static <A extends Annotation> AspectJAnnotation<A> findAnnotation(Method method, Class<A> toLookFor) {
        A result = AnnotationUtils.findAnnotation(method, toLookFor);
        if (result != null) {
            return new AspectJAnnotation<A>(result);
        }
        return null;
    }

    private static class AspectJAnnotationParameterNameDiscoverer
    implements ParameterNameDiscoverer {
        private AspectJAnnotationParameterNameDiscoverer() {
        }

        @Override
        public String[] getParameterNames(Method method) {
            if (method.getParameterTypes().length == 0) {
                return new String[0];
            }
            AspectJAnnotation<?> annotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(method);
            if (annotation == null) {
                return null;
            }
            StringTokenizer strTok = new StringTokenizer(annotation.getArgumentNames(), ",");
            if (strTok.countTokens() > 0) {
                String[] names = new String[strTok.countTokens()];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = strTok.nextToken();
                }
                return names;
            }
            return null;
        }

        @Override
        public String[] getParameterNames(Constructor<?> ctor) {
            throw new UnsupportedOperationException("Spring AOP cannot handle constructor advice");
        }
    }

    protected static class AspectJAnnotation<A extends Annotation> {
        private static final String[] EXPRESSION_PROPERTIES = new String[]{"value", "pointcut"};
        private static Map<Class<?>, AspectJAnnotationType> annotationTypes = new HashMap();
        private final A annotation;
        private final AspectJAnnotationType annotationType;
        private final String pointcutExpression;
        private final String argumentNames;

        public AspectJAnnotation(A annotation) {
            this.annotation = annotation;
            this.annotationType = this.determineAnnotationType(annotation);
            try {
                this.pointcutExpression = this.resolveExpression(annotation);
                this.argumentNames = (String)annotation.getClass().getMethod("argNames", new Class[0]).invoke(annotation, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(annotation + " cannot be an AspectJ annotation", ex);
            }
        }

        private AspectJAnnotationType determineAnnotationType(A annotation) {
            for (Class<?> type : annotationTypes.keySet()) {
                if (!type.isInstance(annotation)) continue;
                return annotationTypes.get(type);
            }
            throw new IllegalStateException("Unknown annotation type: " + annotation.toString());
        }

        private String resolveExpression(A annotation) throws Exception {
            String expression = null;
            for (String methodName : EXPRESSION_PROPERTIES) {
                String candidate;
                Method method;
                try {
                    method = annotation.getClass().getDeclaredMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    method = null;
                }
                if (method == null || !StringUtils.hasText(candidate = (String)method.invoke(annotation, new Object[0]))) continue;
                expression = candidate;
            }
            return expression;
        }

        public AspectJAnnotationType getAnnotationType() {
            return this.annotationType;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public String getPointcutExpression() {
            return this.pointcutExpression;
        }

        public String getArgumentNames() {
            return this.argumentNames;
        }

        public String toString() {
            return this.annotation.toString();
        }

        static {
            annotationTypes.put(Pointcut.class, AspectJAnnotationType.AtPointcut);
            annotationTypes.put(After.class, AspectJAnnotationType.AtAfter);
            annotationTypes.put(AfterReturning.class, AspectJAnnotationType.AtAfterReturning);
            annotationTypes.put(AfterThrowing.class, AspectJAnnotationType.AtAfterThrowing);
            annotationTypes.put(Around.class, AspectJAnnotationType.AtAround);
            annotationTypes.put(Before.class, AspectJAnnotationType.AtBefore);
        }
    }

    protected static enum AspectJAnnotationType {
        AtPointcut,
        AtBefore,
        AtAfter,
        AtAfterReturning,
        AtAfterThrowing,
        AtAround;

    }
}

