/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.config;

import com.att.aft.dme2.internal.springframework.aop.config.AopConfigUtils;
import com.att.aft.dme2.internal.springframework.beans.factory.config.BeanDefinition;
import com.att.aft.dme2.internal.springframework.beans.factory.parsing.BeanComponentDefinition;
import com.att.aft.dme2.internal.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.att.aft.dme2.internal.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AopNamespaceUtils {
    public static final String PROXY_TARGET_CLASS_ATTRIBUTE = "proxy-target-class";
    private static final String EXPOSE_PROXY_ATTRIBUTE = "expose-proxy";

    public static void registerAutoProxyCreatorIfNecessary(ParserContext parserContext, Element sourceElement) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAutoProxyCreatorIfNecessary(parserContext.getRegistry(), parserContext.extractSource(sourceElement));
        AopNamespaceUtils.useClassProxyingIfNecessary(parserContext.getRegistry(), sourceElement);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, parserContext);
    }

    public static void registerAspectJAutoProxyCreatorIfNecessary(ParserContext parserContext, Element sourceElement) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAspectJAutoProxyCreatorIfNecessary(parserContext.getRegistry(), parserContext.extractSource(sourceElement));
        AopNamespaceUtils.useClassProxyingIfNecessary(parserContext.getRegistry(), sourceElement);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, parserContext);
    }

    public static void registerAspectJAnnotationAutoProxyCreatorIfNecessary(ParserContext parserContext, Element sourceElement) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary(parserContext.getRegistry(), parserContext.extractSource(sourceElement));
        AopNamespaceUtils.useClassProxyingIfNecessary(parserContext.getRegistry(), sourceElement);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, parserContext);
    }

    private static void useClassProxyingIfNecessary(BeanDefinitionRegistry registry, Element sourceElement) {
        if (sourceElement != null) {
            boolean exposeProxy;
            boolean proxyTargetClass = Boolean.valueOf(sourceElement.getAttribute(PROXY_TARGET_CLASS_ATTRIBUTE));
            if (proxyTargetClass) {
                AopConfigUtils.forceAutoProxyCreatorToUseClassProxying(registry);
            }
            if (exposeProxy = Boolean.valueOf(sourceElement.getAttribute(EXPOSE_PROXY_ATTRIBUTE)).booleanValue()) {
                AopConfigUtils.forceAutoProxyCreatorToExposeProxy(registry);
            }
        }
    }

    private static void registerComponentIfNecessary(BeanDefinition beanDefinition, ParserContext parserContext) {
        if (beanDefinition != null) {
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition(beanDefinition, "com.att.aft.dme2.internal.springframework.aop.config.internalAutoProxyCreator");
            parserContext.registerComponent(componentDefinition);
        }
    }
}

